package com.transsion.player.ui.render

import android.view.View

class MeasureHelper {

    private var mVideoWidth = 0

    private var mVideoHeight = 0

    private var mCurrentScreenScale = RenderScaleMode.SCREEN_SCALE_DEFAULT

    private var mVideoRotationDegree = 0

    fun setVideoRotation(videoRotationDegree: Int) {
        mVideoRotationDegree = videoRotationDegree
    }

    fun setVideoSize(width: Int, height: Int) {
        mVideoWidth = width
        mVideoHeight = height
    }

    fun setScreenScale(screenScale: RenderScaleMode) {
        if (screenScale == mCurrentScreenScale){
            return
        }
        mCurrentScreenScale = screenScale
    }

    /**
     * 注意：VideoView的宽高一定要定死，否者以下算法不成立
     */
    fun doMeasure(widthMeasureSpecP: Int, heightMeasureSpecP: Int): IntArray {
        var widthMeasureSpec = widthMeasureSpecP
        var heightMeasureSpec = heightMeasureSpecP
        val middle: Int
        if (mVideoRotationDegree == 90 || mVideoRotationDegree == 270) { // 软解码时处理旋转信息，交换宽高
            middle = widthMeasureSpec
            widthMeasureSpec = heightMeasureSpec
            heightMeasureSpec = middle
        }
        var width = View.MeasureSpec.getSize(widthMeasureSpec)
        var height = View.MeasureSpec.getSize(heightMeasureSpec)
        if (mVideoHeight == 0 || mVideoWidth == 0) {
            return intArrayOf(width, height)
        }
        when (mCurrentScreenScale) {
            RenderScaleMode.SCREEN_SCALE_DEFAULT -> if (mVideoWidth * height < width * mVideoHeight) {
                width = height * mVideoWidth / mVideoHeight
            } else if (mVideoWidth * height > width * mVideoHeight) {
                height = width * mVideoHeight / mVideoWidth
            }

            RenderScaleMode.SCREEN_SCALE_ORIGINAL -> {
                width = mVideoWidth
                height = mVideoHeight
            }

            RenderScaleMode.SCREEN_SCALE_16_9 -> if (height > width / 16 * 9) {
                height = width / 16 * 9
            } else {
                width = height / 9 * 16
            }

            RenderScaleMode.SCREEN_SCALE_4_3 -> if (height > width / 4 * 3) {
                height = width / 4 * 3
            } else {
                width = height / 3 * 4
            }

            RenderScaleMode.SCREEN_SCALE_MATCH_PARENT -> {
                width = widthMeasureSpec
                height = heightMeasureSpec
            }

            RenderScaleMode.SCREEN_SCALE_CENTER_CROP -> if (mVideoWidth * height > width * mVideoHeight) {
                width = height * mVideoWidth / mVideoHeight
            } else {
                height = width * mVideoHeight / mVideoWidth
            }

        }
        return intArrayOf(width, height)
    }
}