package com.transsion.player.ui.render

import android.content.Context
import android.graphics.Bitmap
import android.graphics.SurfaceTexture
import android.util.AttributeSet
import android.view.Surface
import android.view.SurfaceView
import android.view.View
import com.transsion.player.config.RenderType

class SurfaceRenderView : SurfaceView, IRenderView {

    private val mMeasureHelper = MeasureHelper()
    private var mSurfaceTexture: SurfaceTexture? = null

    private var mSurface: Surface? = null

    constructor(context: Context) : this(context, null, null)
    constructor(context: Context, renderType: RenderType?) : this(context, null, renderType)
    constructor(context: Context, attrs: AttributeSet?, renderType: RenderType?) : this(context, attrs, 0, renderType)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0, null)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int, renderType: RenderType?) : super(
        context,
        attrs,
        defStyleAttr
    )

    override fun getView(): View = this

    override fun setVideoSize(videoWidth: Int, videoHeight: Int) {
        if (videoWidth > 0 && videoHeight > 0) {
            mMeasureHelper.setVideoSize(videoWidth, videoHeight)
            requestLayout()
        }
    }

    override fun setVideoRotation(degree: Int) {
        mMeasureHelper.setVideoRotation(degree)
        rotation = degree.toFloat()
    }

    override fun setScaleType(scaleType: RenderScaleMode) {
        mMeasureHelper.setScreenScale(scaleType)
        requestLayout()
    }

    override fun doScreenShot(): Bitmap? {
        return null
    }

    override fun release() {
        mSurface?.release()
        mSurfaceTexture?.release()
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        val measuredSize = mMeasureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec)
        setMeasuredDimension(measuredSize[0], measuredSize[1])
    }

}