/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.ijk;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.util.Log;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/transsion/player/ijk/HardwareDecoderChecker;", "", "()V", "TAG", "", "isHardwareAccelerated", "", "codecInfo", "Landroid/media/MediaCodecInfo;", "isHardwareDecoderSupported", "mimeType", "MimeType", "LibPlayer_release"})
public final class HardwareDecoderChecker {
    @NotNull
    public static final HardwareDecoderChecker INSTANCE = new HardwareDecoderChecker();
    @NotNull
    private static final String TAG = "ijkPlayer";

    private HardwareDecoderChecker() {
    }

    public final boolean isHardwareDecoderSupported(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        MediaCodecList codecList = new MediaCodecList(1);
        MediaCodecInfo[] codecInfos = codecList.getCodecInfos();
        Intrinsics.checkNotNullExpressionValue((Object)codecInfos, (String)"codecInfos");
        for (MediaCodecInfo codecInfo : codecInfos) {
            if (codecInfo.isEncoder()) continue;
            try {
                Object[] supportedTypes = codecInfo.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)supportedTypes, (String)"supportedTypes");
                if (!ArraysKt.contains((Object[])supportedTypes, (Object)mimeType)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)codecInfo, (String)"codecInfo");
                if (!this.isHardwareAccelerated(codecInfo)) continue;
                Log.d((String)TAG, (String)("\u627e\u5230\u652f\u6301 " + mimeType + " \u7684\u786c\u4ef6\u89e3\u7801\u5668\uff1a" + codecInfo.getName()));
                return true;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("\u68c0\u67e5\u89e3\u7801\u5668 " + codecInfo.getName() + " \u5931\u8d25"), (Throwable)e);
            }
        }
        Log.d((String)TAG, (String)("\u4e0d\u652f\u6301 " + mimeType + " \u7684\u786c\u4ef6\u89e3\u7801"));
        return false;
    }

    private final boolean isHardwareAccelerated(MediaCodecInfo codecInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            return codecInfo.isHardwareAccelerated();
        }
        String string = codecInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"codecInfo.name");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String codecName = string2;
        return StringsKt.startsWith$default((String)codecName, (String)"omx.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)codecName, (String)"c2.", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/transsion/player/ijk/HardwareDecoderChecker$MimeType;", "", "()V", "H264", "", "H265", "MPEG4", "VP8", "VP9", "LibPlayer_release"})
    public static final class MimeType {
        @NotNull
        public static final MimeType INSTANCE = new MimeType();
        @NotNull
        public static final String H264 = "video/avc";
        @NotNull
        public static final String H265 = "video/hevc";
        @NotNull
        public static final String MPEG4 = "video/mp4v-es";
        @NotNull
        public static final String VP9 = "video/vp9";
        @NotNull
        public static final String VP8 = "video/x-vnd.on2.vp8";

        private MimeType() {
        }
    }
}

