/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.shorttv.preload;

import android.content.Context;
import android.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.offline.Download;
import androidx.media3.exoplayer.offline.DownloadManager;
import androidx.media3.exoplayer.scheduler.Requirements;
import com.transsion.player.MediaSource;
import com.transsion.player.exo.DemoUtil;
import com.transsion.player.shorttv.preload.VideoDownloadBean;
import com.transsion.player.shorttv.preload.VideoPreloadHelper;
import com.transsion.player.shorttv.preload.VideoPreloadManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010*\u0001\r\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0013J\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activeTasks", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/transsion/player/shorttv/preload/VideoDownloadBean;", "currentDownloadingUuid", "currentPosition", "", "listener", "com/transsion/player/shorttv/preload/VideoPreloadHelper$listener$1", "Lcom/transsion/player/shorttv/preload/VideoPreloadHelper$listener$1;", "shortTVItemList", "", "Lcom/transsion/player/MediaSource;", "add", "", "mediaSource", "index", "changeSelect", "position", "checkToPause", "checkToStart", "createDownloadRequest", "shortTVItem", "loadNext", "pause", "release", "remove", "key", "resume", "Companion", "LibPlayer_release"})
@UnstableApi
public final class VideoPreloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final List<MediaSource> shortTVItemList;
    private int currentPosition;
    @Nullable
    private String currentDownloadingUuid;
    @NotNull
    private final listener.1 listener;
    @NotNull
    private final ConcurrentHashMap<String, VideoDownloadBean> activeTasks;
    public static final int PRELOAD_COUNT = 5;
    public static final long PRELOAD_FIRST_SIZE = 307200L;
    public static final int PAUSE_REASON = 10086;
    public static final boolean PRELOAD_ALL = false;
    @NotNull
    public static final String TAG = "VideoPreloadHelper";

    public VideoPreloadHelper(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.shortTVItemList = new CopyOnWriteArrayList();
        this.listener = new DownloadManager.Listener(this){
            final /* synthetic */ VideoPreloadHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInitialized(@NotNull DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadsPausedChanged(@NotNull DownloadManager downloadManager, boolean downloadsPaused) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }

            public void onDownloadChanged(@NotNull DownloadManager downloadManager, @NotNull Download download, @Nullable Exception finalException) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
                Log.e((String)"VideoPreloadHelper", (String)("onDownloadChanged:  download.requestId:" + download.request.id + "     bytesDownloaded:" + download.getBytesDownloaded() + "  contentLength:" + download.contentLength + "  percentDownloaded:" + download.getPercentDownloaded()));
                VideoDownloadBean videoDownloadBean = (VideoDownloadBean)VideoPreloadHelper.access$getActiveTasks$p(this.this$0).get(download.request.id);
                if (videoDownloadBean != null) {
                    VideoDownloadBean videoDownloadBean2;
                    VideoDownloadBean $this$onDownloadChanged_u24lambda_u240 = videoDownloadBean2 = videoDownloadBean;
                    boolean bl = false;
                    $this$onDownloadChanged_u24lambda_u240.setDownloadLength(download.getBytesDownloaded());
                    $this$onDownloadChanged_u24lambda_u240.setContentLength(download.contentLength);
                }
                if (Intrinsics.areEqual((Object)download.request.id, (Object)VideoPreloadHelper.access$getCurrentDownloadingUuid$p(this.this$0)) && (download.state == 1 || download.state == 3 || download.state == 4)) {
                    VideoPreloadHelper.access$setCurrentDownloadingUuid$p(this.this$0, null);
                    this.this$0.loadNext();
                }
            }

            public void onDownloadRemoved(@NotNull DownloadManager downloadManager, @NotNull Download download) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)download, (String)"download");
            }

            public void onIdle(@NotNull DownloadManager downloadManager) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Log.e((String)"VideoPreloadHelper", (String)"onIdle:");
                this.this$0.loadNext();
            }

            public void onRequirementsStateChanged(@NotNull DownloadManager downloadManager, @NotNull Requirements requirements, int notMetRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
                Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
            }

            public void onWaitingForRequirementsChanged(@NotNull DownloadManager downloadManager, boolean waitingForRequirements) {
                Intrinsics.checkNotNullParameter((Object)downloadManager, (String)"downloadManager");
            }
        };
        this.activeTasks = new ConcurrentHashMap();
        DemoUtil.getDownloadManager(this.context).addListener((DownloadManager.Listener)this.listener);
    }

    public final void changeSelect(int position) {
        Log.e((String)TAG, (String)("changeSelect  position:" + position));
        if (this.currentPosition == position) {
            return;
        }
        this.currentDownloadingUuid = null;
        this.currentPosition = position;
        this.checkToPause(this.currentPosition);
        this.checkToStart(this.currentPosition + 1);
    }

    public final void pause() {
        this.checkToPause(this.currentPosition);
        this.currentPosition = -1;
    }

    public final void resume(int position) {
        this.checkToStart(position);
    }

    public final void remove(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.activeTasks.remove(key2);
        VideoPreloadManager.INSTANCE.removePreload(key2);
    }

    public final void loadNext() {
        if (this.currentPosition < 0) {
            return;
        }
        int position = this.currentPosition;
        if (this.currentDownloadingUuid != null) {
            return;
        }
        VideoPreloadManager.INSTANCE.runOnPreloadThread(() -> VideoPreloadHelper.loadNext$lambda$2(this, position));
    }

    private final VideoDownloadBean createDownloadRequest(int position, MediaSource shortTVItem) {
        VideoDownloadBean data = this.activeTasks.get(shortTVItem.getKey());
        if (data != null) {
            Log.e((String)TAG, (String)("createDownloadRequest [from map] position:" + position + "  shortTVItem:" + shortTVItem));
            return data;
        }
        String cacheKey = shortTVItem.getKey();
        VideoDownloadBean shortTVDownloadBean = VideoPreloadManager.INSTANCE.createDownloadRequest(shortTVItem);
        ((Map)this.activeTasks).put(cacheKey, shortTVDownloadBean);
        Log.e((String)TAG, (String)("createDownloadRequest [from new] position:" + position + "  shortTVItem:" + shortTVItem));
        return shortTVDownloadBean;
    }

    private final void checkToPause(int position) {
        boolean bl = 0 <= position ? position < this.shortTVItemList.size() : false;
        if (bl) {
            MediaSource mediaSource = this.shortTVItemList.get(position);
            if (mediaSource == null) {
                return;
            }
            MediaSource shortTVItem = mediaSource;
            Log.e((String)TAG, (String)("checkToPause   position:" + position + "  shortTVItem:" + shortTVItem));
            VideoPreloadManager.INSTANCE.stopPreload(shortTVItem.getKey());
        }
    }

    private final void checkToStart(int position) {
        boolean bl = 0 <= position ? position < this.shortTVItemList.size() : false;
        if (bl) {
            MediaSource mediaSource = this.shortTVItemList.get(position);
            if (mediaSource == null) {
                return;
            }
            MediaSource shortTVItem = mediaSource;
            VideoPreloadManager.INSTANCE.runOnPreloadThread(() -> VideoPreloadHelper.checkToStart$lambda$4(shortTVItem, this));
        }
    }

    public final void release() {
        DemoUtil.getDownloadManager(this.context).removeListener((DownloadManager.Listener)this.listener);
        this.pause();
    }

    public final void add(@NotNull MediaSource mediaSource) {
        Intrinsics.checkNotNullParameter((Object)mediaSource, (String)"mediaSource");
        this.shortTVItemList.add(mediaSource);
        this.loadNext();
    }

    public final void add(int index, @NotNull MediaSource mediaSource) {
        Intrinsics.checkNotNullParameter((Object)mediaSource, (String)"mediaSource");
        if (index <= this.shortTVItemList.size()) {
            this.shortTVItemList.add(index, mediaSource);
        }
        this.loadNext();
    }

    private static final void loadNext$lambda$2(VideoPreloadHelper this$0, int $position) {
        int start;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int size = this$0.shortTVItemList.size();
        int skipCount = 0;
        skipCount = 1;
        boolean isCurrentComplete = false;
        Log.e((String)TAG, (String)("loadNext\uff0c position:" + $position + "   size:" + size));
        int n = RangesKt.coerceAtMost((int)(start + 5), (int)size);
        for (int index = start = $position + 1; index < n; ++index) {
            MediaSource shortTVItem;
            if (this$0.shortTVItemList.get(index) == null) continue;
            VideoDownloadBean it = this$0.createDownloadRequest(index, shortTVItem);
            boolean bl = false;
            it.setMaxLength(307200L);
            if (it.getDownloadLength() < it.getMaxLength()) {
                Log.e((String)TAG, (String)("\u975e\u5f53\u524d\u9009\u4e2d  \u4e0b\u8f7d\u5927\u5c0f downloadLength:" + it.getDownloadLength() + "  index:" + index));
                this$0.currentDownloadingUuid = it.getId();
                VideoPreloadManager.INSTANCE.preloadVideo(it);
                return;
            }
            if (it.getDownloadLength() == it.getContentLength()) {
                ++skipCount;
            }
            Log.e((String)TAG, (String)("\u975e\u5f53\u524d\u9009\u4e2d  \u4e0b\u8f7d\u5927\u5c0f downloadLength:" + it.getDownloadLength() + " \u5927\u4e8e\u6700\u5c0f\u4e0b\u8f7d\uff0c\u8df3\u8fc7 index:" + index));
        }
        Log.e((String)TAG, (String)"\u4e0d\u7528\u5168\u91cf\u4e0b\u8f7d");
    }

    private static final void checkToStart$lambda$4(MediaSource $shortTVItem, VideoPreloadHelper this$0) {
        VideoDownloadBean videoDownloadBean;
        Intrinsics.checkNotNullParameter((Object)$shortTVItem, (String)"$shortTVItem");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VideoDownloadBean $this$checkToStart_u24lambda_u244_u24lambda_u243 = videoDownloadBean = VideoPreloadManager.INSTANCE.preloadVideoAsync($shortTVItem);
        boolean bl = false;
        ((Map)this$0.activeTasks).put($shortTVItem.getKey(), $this$checkToStart_u24lambda_u244_u24lambda_u243);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getActiveTasks$p(VideoPreloadHelper $this) {
        return $this.activeTasks;
    }

    public static final /* synthetic */ String access$getCurrentDownloadingUuid$p(VideoPreloadHelper $this) {
        return $this.currentDownloadingUuid;
    }

    public static final /* synthetic */ void access$setCurrentDownloadingUuid$p(VideoPreloadHelper $this, String string2) {
        $this.currentDownloadingUuid = string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/transsion/player/shorttv/preload/VideoPreloadHelper$Companion;", "", "()V", "PAUSE_REASON", "", "PRELOAD_ALL", "", "PRELOAD_COUNT", "PRELOAD_FIRST_SIZE", "", "TAG", "", "LibPlayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

