/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.player.ui.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import com.transsion.player.config.RenderType;
import com.transsion.player.ui.render.IRenderView;
import com.transsion.player.ui.render.MeasureHelper;
import com.transsion.player.ui.render.RenderScaleMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0014J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/transsion/player/ui/render/SurfaceRenderView;", "Landroid/view/SurfaceView;", "Lcom/transsion/player/ui/render/IRenderView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "renderType", "Lcom/transsion/player/config/RenderType;", "(Landroid/content/Context;Lcom/transsion/player/config/RenderType;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;Lcom/transsion/player/config/RenderType;)V", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILcom/transsion/player/config/RenderType;)V", "mMeasureHelper", "Lcom/transsion/player/ui/render/MeasureHelper;", "mSurface", "Landroid/view/Surface;", "mSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "doScreenShot", "Landroid/graphics/Bitmap;", "getView", "Landroid/view/View;", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "release", "setScaleType", "scaleType", "Lcom/transsion/player/ui/render/RenderScaleMode;", "setVideoRotation", "degree", "setVideoSize", "videoWidth", "videoHeight", "LibPlayer_release"})
public final class SurfaceRenderView
extends SurfaceView
implements IRenderView {
    @NotNull
    private final MeasureHelper mMeasureHelper;
    @Nullable
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private Surface mSurface;

    public SurfaceRenderView(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, null, null);
    }

    public SurfaceRenderView(@NotNull Context context2, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, null, renderType);
    }

    public SurfaceRenderView(@NotNull Context context2, @Nullable AttributeSet attrs, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, attrs, 0, renderType);
    }

    public SurfaceRenderView(@NotNull Context context2, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, attrs, 0, null);
    }

    public SurfaceRenderView(@NotNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable RenderType renderType) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attrs, defStyleAttr);
        this.mMeasureHelper = new MeasureHelper();
    }

    @Override
    @NotNull
    public View getView() {
        return (View)this;
    }

    @Override
    public void setVideoSize(int videoWidth, int videoHeight) {
        if (videoWidth > 0 && videoHeight > 0) {
            this.mMeasureHelper.setVideoSize(videoWidth, videoHeight);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int degree) {
        this.mMeasureHelper.setVideoRotation(degree);
        this.setRotation(degree);
    }

    @Override
    public void setScaleType(@NotNull RenderScaleMode scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        this.mMeasureHelper.setScreenScale(scaleType);
        this.requestLayout();
    }

    @Override
    @Nullable
    public Bitmap doScreenShot() {
        return null;
    }

    @Override
    public void release() {
        block1: {
            Surface surface = this.mSurface;
            if (surface != null) {
                surface.release();
            }
            SurfaceTexture surfaceTexture = this.mSurfaceTexture;
            if (surfaceTexture == null) break block1;
            surfaceTexture.release();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] measuredSize = this.mMeasureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measuredSize[0], measuredSize[1]);
    }
}

