package com.tn.lib.logger.xlog.conf

import com.elvishew.xlog.printer.file.clean.CleanStrategy
import java.io.File

class FileSizeCleanStrategy : CleanStrategy {

    private val MAX_FILE_SIZE = 1024 * 1024 * 5L

    private val day = 24 * 60 * 60 * 1000
    private val now = System.currentTimeMillis()
    /**
     * 1 如果单个文件>5M将会清除
     * 2 日志文件最长保存时间为15天
     */
    override fun shouldClean(file: File?): Boolean {
        if (file?.isFile == true) {
            if (isExpired(file)) return true
            if (file.length() > MAX_FILE_SIZE) {
                return true
            }
        }
        return false
    }

    private fun isExpired(file: File?): Boolean {
        if (file == null) return false
        val lastModified = file.lastModified()
        // 超过15天的logger删除
        if ((now - lastModified) / day >= 15) {
            return true
        }
        return false
    }
}