package com.tn.lib.logger.xlog.impl

import com.elvishew.xlog.XLog
import com.google.gson.Gson
import com.tn.lib.logger.xlog.ILogger

class XLogImpl : ILogger {
    companion object {
        val instance: XLogImpl by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            XLogImpl()
        }
    }

    private var mGson: Gson = Gson()

    override fun i(tag: String, vararg msg: String) {
        XLog.tag(tag).i(msg)
    }

    override fun i(msg: String) {
        XLog.i(msg)
    }

    override fun v(tag: String, vararg msg: String) {
        XLog.tag(tag).v(msg)
    }

    override fun v(msg: String) {
        XLog.v(msg)
    }

    override fun d(tag: String, vararg msg: String) {
        XLog.tag(tag).d(msg)
    }

    override fun d(msg: String) {
        XLog.d(msg)
    }

    override fun w(tag: String, vararg msg: String) {
        XLog.tag(tag).w(msg)
    }

    override fun w(msg: String) {
        XLog.w(msg)
    }

    override fun e(tag: String, vararg msg: String) {
        XLog.tag(tag).e(msg)
    }

    override fun e(msg: String) {
        XLog.e(msg)
    }

    override fun json(tag: String, obj: Any?) {
        if (obj == null) {
            return
        }
        try {
            if (obj is String || obj is Int || obj is Float
                || obj is Double || obj is Long || obj is Byte || obj is Short
                || obj is Boolean || obj is Char
            ) {
                XLog.tag(tag).d(obj)
            } else {
                XLog.tag(tag).json(mGson.toJson(obj))
            }
        } catch (e: Exception) {
            XLog.e(e?.stackTrace)
            e.printStackTrace()
        }
    }

    override fun json(obj: Any?) {
        if (obj == null) {
            return
        }
        try {
            if (obj is String || obj is Int || obj is Float
                || obj is Double || obj is Long || obj is Byte || obj is Short
                || obj is Boolean || obj is Char
            ) {
                XLog.d(obj)
            } else {
                XLog.json(mGson.toJson(obj))
            }
        } catch (e: Exception) {
            XLog.e(e.stackTrace)
            e.printStackTrace()
        }
    }


    override fun xml(tag: String, xmlStr: String) {
        XLog.tag(tag).xml(xmlStr)
    }

    override fun xml(xmlStr: String) {
        XLog.xml(xmlStr)
    }
}