package com.transsion.base.report.athena

import android.os.SystemClock

/**
 *
 * @Description:    埋点页面
 * @Author:         xusong.yang
 * @CreateDate:     2022/8/18$ 10:11$
 * @Version:        1.0
 */
interface ILogView {

    val logViewConfig: LogViewConfig?

    fun newLogViewConfig(): LogViewConfig? = null

    fun onPageResume() {
        logViewConfig?.let {
            it.resumeTime = SystemClock.elapsedRealtime()
            if (it.needPv) {
                Report.reportPV(it)
            }
        }
    }

    fun onPagePause() {
        logViewConfig?.let {
            if (it.needTerminal) {
                Report.reportPT(it)
            }
        }
    }

}