package com.transsion.base.report.athena

/**
 *
 * @Description:    页面打点的参数
 * @Author:         xusong.yang
 * @CreateDate:     2022/8/18$ 15:17$
 * @Version:        1.0
 */
data class LogViewConfig(
    /**
     * 页面名称
     */
    val pageName: String,
    /**
     * needAddToPageFrom 是否需要增加到各级页面来源。临时dialog类的页面传递false
     */
    val needAddToPageFrom: Boolean = true
) {


    /**
     * 通用参数
     */
    val paramsMap: HashMap<String, String?> = HashMap()


    /**
     * 页面名称
     */
    var fromPageName: String? = null

    /**
     * 页面类型，页面或者弹窗（暂时不用）
     */
    var pageType: String = ""

    /**
     * 是否需求打PV事件
     */
    var needPv: Boolean = false

    /**
     * 是否需求打Terminal事件
     */
    var needTerminal: Boolean = true


    /**
     * 显示的时间 ，注意为了防止改时间之类的 用的是 SystemClock.elapsedRealtime()
     */
    var resumeTime: Long = -1

    /**
     * 页面是否加载成功
     */
    var isLoadSuccess: Boolean = false

    /**
     * 推荐信息透传
     */
    var ops: String? = null
}