/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.base.report.athena;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.blankj.utilcode.util.Utils;
import com.tn.lib.logger.Logger;
import com.transsion.athenacust.AthenaCust;
import com.transsion.base.report.athena.LogViewConfig;
import com.transsion.base.report.athena.ReportApi;
import com.transsion.ga.AthenaAnalytics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ$\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ$\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ$\u0010 \u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ2\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050%J,\u0010&\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ,\u0010'\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ.\u0010(\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dH\u0002J$\u0010&\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dJ\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00152\b\u0010+\u001a\u0004\u0018\u00010\u0005J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020\u0005J\u001c\u00100\u001a\u00020\u00052\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/transsion/base/report/athena/Report;", "", "<init>", "()V", "TAG", "", "EXT", "mLastPageName", "api", "Lcom/transsion/base/report/athena/ReportApi;", "singleExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "initSDK", "", "context", "Landroid/app/Application;", "debug", "", "channelId", "appId", "", "reportPV", "logConfig", "Lcom/transsion/base/report/athena/LogViewConfig;", "reportPT", "reportDialog", "pageName", "map", "", "reportShow", "reportClick", "reportDelete", "reportUseTime", "event", "useTime", "", "", "reportEvent", "reportUIEvent", "addToRecentEvent", "loginActive", "userType", "userid", "track", "bundle", "Landroid/os/Bundle;", "getLastPageName", "map2Jsonstr", "report_psRelease"})
public final class Report {
    @NotNull
    public static final Report INSTANCE = new Report();
    @NotNull
    public static final String TAG = "Report";
    @NotNull
    private static final String EXT = "ext";
    @NotNull
    private static String mLastPageName = "";
    @Nullable
    private static ReportApi api;
    private static final ExecutorService singleExecutor;

    private Report() {
    }

    public final void initSDK(@NotNull Application context, boolean debug, @NotNull ReportApi api, @NotNull String channelId, int appId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        AthenaAnalytics.setWorkMode((int)1);
        AthenaAnalytics.init((Context)((Context)context), (String)channelId, (int)appId, (boolean)true, (boolean)true);
        AthenaAnalytics.setTest((boolean)debug);
        AthenaAnalytics.enable((boolean)true);
        AthenaAnalytics.setDelayTime((int)2000);
        AthenaAnalytics.submitAll();
        Report.api = api;
        Logger.Companion.d$default(Logger.Companion, TAG, "initSDK debug " + debug, false, 4, null);
    }

    public final void reportPV(@NotNull LogViewConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Map map = logConfig.getParamsMap();
        String string = "page_from";
        String string2 = logConfig.getFromPageName();
        if (string2 == null) {
            string2 = mLastPageName;
        }
        String string3 = string2;
        map.put(string, string3);
        String string4 = logConfig.getOps();
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            ((Map)logConfig.getParamsMap()).put("ops", it);
        }
        this.reportUIEvent(logConfig.getPageName(), "pv", (Map<String, String>)logConfig.getParamsMap());
    }

    public final void reportPT(@NotNull LogViewConfig logConfig) {
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Map map = logConfig.getParamsMap();
        String string = "page_from";
        String string2 = logConfig.getFromPageName();
        if (string2 == null) {
            string2 = mLastPageName;
        }
        String string3 = string2;
        map.put(string, string3);
        ((Map)logConfig.getParamsMap()).put("duration", String.valueOf(SystemClock.elapsedRealtime() - logConfig.getResumeTime()));
        ((Map)logConfig.getParamsMap()).put("is_load_success", String.valueOf(logConfig.isLoadSuccess()));
        String string4 = logConfig.getOps();
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            ((Map)logConfig.getParamsMap()).put("ops", it);
        }
        this.reportUIEvent(logConfig.getPageName(), "pt", (Map<String, String>)logConfig.getParamsMap());
        if (!TextUtils.equals((CharSequence)mLastPageName, (CharSequence)logConfig.getPageName()) && logConfig.getNeedAddToPageFrom()) {
            mLastPageName = logConfig.getPageName();
        }
    }

    public final void reportDialog(@NotNull String pageName, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent(pageName, "dialog_show", map);
    }

    public final void reportShow(@NotNull String pageName, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent(pageName, "browse", map);
    }

    public final void reportClick(@NotNull String pageName, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent(pageName, "click", map);
    }

    public final void reportDelete(@NotNull String pageName, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent(pageName, "delete", map);
    }

    public final void reportUseTime(@NotNull String pageName, @NotNull String event, long useTime, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        map.put("duration", String.valueOf(useTime));
        this.reportUIEvent(pageName, event, map);
    }

    public final void reportEvent(@NotNull String pageName, @NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.reportUIEvent(pageName, event, map);
    }

    public final void reportUIEvent(@NotNull String pageName, @NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)pageName, (String)"pageName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        singleExecutor.execute(() -> Report.reportUIEvent$lambda$2(event, pageName, map));
    }

    private final void addToRecentEvent(String pageName, String event, Map<String, String> map) {
        block0: {
            ReportApi reportApi = api;
            if (reportApi == null) break block0;
            reportApi.addToRecentEvent(pageName, event, map);
        }
    }

    public final void reportEvent(@NotNull String event, @NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        singleExecutor.execute(() -> Report.reportEvent$lambda$3(event, map));
    }

    public final void loginActive(int userType, @Nullable String userid) {
        singleExecutor.execute(() -> Report.loginActive$lambda$4(userType, userid));
    }

    private final void track(String event, Bundle bundle) {
        try {
            bundle.putString("vaid", AthenaAnalytics.getAppVAID((Context)((Context)Utils.getApp())));
            ReportApi reportApi = api;
            Bundle commonBundle = reportApi != null ? reportApi.addCommonParams(event, bundle) : null;
            Pair<Short, String> pair = api;
            if (pair != null && (pair = pair.getAccount()) != null) {
                Pair<Short, String> pair2;
                Pair<Short, String> $this$track_u24lambda_u245 = pair2 = pair;
                boolean bl = false;
                AthenaAnalytics.setAccount((short)((Number)$this$track_u24lambda_u245.getFirst()).shortValue(), (String)((String)$this$track_u24lambda_u245.getSecond()));
            }
            new AthenaCust(event).trackCommon(commonBundle, null).submit();
        }
        catch (Exception ignore) {
            Logger.Companion.e("report", "event " + event + " exception " + ignore, true);
        }
    }

    @NotNull
    public final String getLastPageName() {
        return mLastPageName;
    }

    @NotNull
    public final String map2Jsonstr(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        String string = new JSONObject(map).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void reportUIEvent$lambda$2(String $event, String $pageName, Map $map) {
        Logger.Companion.d$default(Logger.Companion, TAG, "event=" + $event + "  pageName=" + $pageName + " map=" + $map, false, 4, null);
        Bundle bundle = new Bundle();
        bundle.putString("page_name", $pageName);
        String map2Jsonstr = INSTANCE.map2Jsonstr($map);
        bundle.putString(EXT, map2Jsonstr);
        INSTANCE.track($event, bundle);
        INSTANCE.addToRecentEvent($pageName, $event, $map);
    }

    private static final void reportEvent$lambda$3(String $event, Map $map) {
        Logger.Companion.d$default(Logger.Companion, TAG, "reportEvent event=" + $event + " map=" + $map + ' ', false, 4, null);
        Bundle bundle = new Bundle();
        String map2Jsonstr = INSTANCE.map2Jsonstr($map);
        bundle.putString(EXT, map2Jsonstr);
        INSTANCE.track($event, bundle);
    }

    private static final void loginActive$lambda$4(int $userType, String $userid) {
        Logger.Companion.d$default(Logger.Companion, TAG, "loginActive:userType" + $userType + ",userid:" + $userid, false, 4, null);
        String event = "login_active";
        HashMap map = new HashMap();
        ((Map)map).put("userType", String.valueOf($userType));
        Map map2 = map;
        String string = $userid;
        if (string == null) {
            string = "0";
        }
        map2.put("userId", string);
        String json = INSTANCE.map2Jsonstr(map);
        Bundle bundle = new Bundle();
        bundle.putString("event", event);
        bundle.putString(EXT, json);
        INSTANCE.track(event, bundle);
    }

    static {
        singleExecutor = Executors.newSingleThreadExecutor();
    }
}

