package com.transsion.search

import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import android.os.Build
import android.text.style.DynamicDrawableSpan
import android.text.style.ImageSpan
import androidx.fragment.app.FragmentActivity
import com.alibaba.android.arouter.launcher.ARouter
import com.transsion.baselib.utils.PlayModeUtil
import com.transsion.baselib.utils.openDeeplink
import com.transsion.baselib.utils.openExternalBrowser
import com.transsion.moviedetailapi.MovieDetailConstants
import com.transsion.moviedetailapi.MovieDetailPageIdentity
import com.transsion.moviedetailapi.SubjectType
import com.transsion.moviedetailapi.bean.Subject
import com.transsnet.downloader.DownloadManagerApi

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description:
 */
fun getResultSplitSpan(context: Context): ImageSpan {
    val subjectImageId = R.drawable.ic_search_result_split
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
        ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_CENTER)
    } else {
        ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_BASELINE)
    }
}

fun getImageSpan(context: Context, res: Int): ImageSpan {
    return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
        ImageSpan(context, res, DynamicDrawableSpan.ALIGN_CENTER)
    } else {
        ImageSpan(context, res, DynamicDrawableSpan.ALIGN_BASELINE)
    }
}

/**
 * 下载模式：未下载 -> 弹出下载弹框，已下载 -> 进播放页
 * 流媒体模式：进详情页
 */
fun gotoPlayOrDownload(subjectItem: Subject?, pageName: String, context: Context, playModule: String): String {
    val moduleName: String

    if (subjectItem?.subjectType == SubjectType.SHORT_TV.value) {
        //短剧下载按钮点击-打开下载弹窗
        DownloadManagerApi.INSTANCE.downloadShortTV(
            activity = context as FragmentActivity,
            page_from = pageName,
            groupId = "",
            opss = subjectItem.ops,
            moduleName = "download_subject",
            scroll2Download = true,
            subject = subjectItem
        )
        moduleName = "download_subject"

    } else {
        if (PlayModeUtil.isStreamMode()) {
            goSubjectDetail(subjectItem, playModule)
            moduleName = "play_subject"

        } else {
            val playAvailable = DownloadManagerApi.INSTANCE.playAvailable(
                subjectId = subjectItem?.subjectId,
                resourceId = subjectItem?.resourceDetector?.resourceId,
                subjectItem?.isSeries() == true
            )
            if (playAvailable) {
                subjectItem?.subjectId?.let {
                    DownloadManagerApi.INSTANCE.playNow(it, context, pageFrom = pageName)
                }
                moduleName = "play_subject"

            } else {
                DownloadManagerApi.INSTANCE.addDownloadListWithDialog(
                    context as FragmentActivity,
                    subjectItem,
                    pageName,
                    null,
                    subjectItem?.ops,
                    resource = subjectItem?.resourceDetector?.resourceLink ?: ""
                )
                moduleName = "download_subject"
            }
        }
    }
    return moduleName
}

fun goSubjectDetail(item: Subject?, playModule: String) {
    if (item == null) return
    if (item.isJumpBrowser()) {
        //跳转H5
        item.playUrl?.playUrl?.openExternalBrowser()
    } else if (item.isJumpWebview()){
        //跳转Webview
        item.playUrl?.playUrl?.openDeeplink()
    } else {
        ARouter.getInstance().build(MovieDetailPageIdentity.MOVIE_DETAIL)
            .withInt(MovieDetailConstants.SUBJECT_TYPE, item.subjectType ?: SubjectType.MOVIE.value)
            .withString(MovieDetailConstants.SUBJECT_ID, item.subjectId)
            .withString(MovieDetailConstants.MODULE_NAME, playModule)
            .withInt(MovieDetailConstants.SEASON, item.season)
            .withBoolean("autoPlay", true)
            .withString(MovieDetailConstants.OPS, item.ops)
            .navigation()
    }
}

fun isTablet(resources: Resources): Boolean = (resources.configuration.screenLayout and Configuration.SCREENLAYOUT_SIZE_MASK) >= Configuration.SCREENLAYOUT_SIZE_LARGE
