package com.transsion.search.adapter

import androidx.recyclerview.widget.RecyclerView
import com.blankj.utilcode.util.SizeUtils
import com.blankj.utilcode.util.Utils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.search.R
import com.transsion.search.bean.Season


class SeachAccurateSeasonsAdapter(layoutResId: Int = R.layout.item_accurate_subject_seasons) :
    BaseQuickAdapter<Season, BaseViewHolder>(layoutResId) {

    private val movieDesignW = SizeUtils.dp2px(104f)        // 三列时设计宽
    private val movieDesignH = SizeUtils.dp2px(32f)        // 三列时设计高
    private val size40 = SizeUtils.dp2px(40f)       // 3列是间隔12+8+8+12
    private val screenW = com.tn.lib.utils.ScreenUtils.getWidth(Utils.getApp())
    private val movieW = (screenW - size40) / 3       // movie、tv实际宽
    private val movieH = (movieW * (movieDesignH * 1.0f / movieDesignW)).toInt()                    // movie、tv实际高l

    private val MAX_VALUE = 5
    private var mShowMore = true

    override fun convert(holder: BaseViewHolder, item: Season) {
        val position = getItemPosition(item)
        val params = holder.itemView.layoutParams as RecyclerView.LayoutParams
        params.height = movieH
        if (position >= MAX_VALUE && mShowMore) {
            holder.setVisible(R.id.tvName, false)
            holder.setVisible(R.id.tvMore, true)
        } else {
            holder.setVisible(R.id.tvName, true)
            holder.setVisible(R.id.tvMore, false)
            holder.setText(R.id.tvName, context.getString(R.string.seasons, item.se.toString()))
        }
    }

    fun needShowMore(showMore: Boolean) {
        mShowMore = showMore
    }

}

