package com.transsion.search.adapter

import android.content.Context
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.transsion.baselib.helper.DataHelper
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.adapter.provider.SearchAssociationProvider
import com.transsion.search.adapter.provider.SearchWorkProvider
import com.transsion.search.bean.SearchSubject

/*layoutResId: Int = R.layout.item_works_layout*/
@Deprecated("")
class SearchWorkAdapter(context: Context, datas: MutableList<SearchSubject>) :
    BaseProviderMultiAdapter<SearchSubject>(datas), LoadMoreModule {

    companion object {
        //全部作品
        const val SEARCH_WORK_TYPE = 0
        //相关系列
        const val SEARCH_ASSOCIATION_TYPE = 1


        //串联搜索点击，item曝光，item点击 埋点的id
        var trid = ""
        fun report(item: Subject, sequence: Int) {
            val map = HashMap<String, String>()
            map["subject_id"] = item.subjectId ?: ""
            map["has_resource"] = item.hasResource.toString()
            map["ops"] = item.ops ?: ""
            map["sequence"] = sequence.toString()
            if (trid.isNotEmpty()) {
                map["trid"] = trid
            }
            DataHelper.reportBrowseEvent("searchresult", map)
        }
    }

    init {
        addItemProvider(SearchWorkProvider(context))
        addItemProvider(SearchAssociationProvider())
    }
    override fun getItemType(data: List<SearchSubject>, position: Int): Int {
        return data[position].viewType
    }


}