package com.transsion.search.adapter.provider

import android.view.View
import androidx.appcompat.widget.AppCompatTextView
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.android.material.imageview.ShapeableImageView
import com.tn.lib.ext.gone
import com.tn.lib.ext.visible
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.adapter.SearchWorkAdapter
import com.transsion.search.bean.SearchSubject

class SearchAssociationProvider: BaseItemProvider<SearchSubject>() {

    private val designW = SizeUtils.dp2px(72f)
    private val designH = SizeUtils.dp2px(96f)


    override val layoutId: Int
        get() = R.layout.item_associate_subject

    override val itemViewType: Int
        get() = SearchWorkAdapter.SEARCH_ASSOCIATION_TYPE

    override fun convert(helper: BaseViewHolder, item: SearchSubject) {
        helper.getViewOrNull<ShapeableImageView>(R.id.ivCover)?.apply {
            val url = ImageHelper.getReSizeUrl(item.verticalRank?.cover?.url?:"", designW, designH)
            ImageHelper.loadNet(context, this, url)
        }
        helper.getViewOrNull<AppCompatTextView>(R.id.tvTitle)?.apply {
            text = item.verticalRank?.title
        }
        helper.getViewOrNull<AppCompatTextView>(R.id.tvDes)?.apply {
            text = item.verticalRank?.description
        }

        helper.getViewOrNull<View>(R.id.divider)?.apply {
            if (item.showDivider) {
                visible()
            } else {
                gone()
            }
        }
    }
}