package com.transsion.search.adapter.provider

import android.annotation.SuppressLint
import android.widget.ImageView
import androidx.appcompat.widget.AppCompatTextView
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baselib.db.video.VideoDetailPlayBean
import com.transsion.baseui.image.ImageHelper
import com.transsion.moviedetailapi.getSubjectIconId
import com.transsion.moviedetailapi.helper.SubjectHelper
import com.transsion.search.R

class SearchWorkHistoryProvider : BaseItemProvider<VideoDetailPlayBean>() {

    override val layoutId: Int
        get() = R.layout.item_works_layout_room

    override val itemViewType: Int
        get() = 1

    @SuppressLint("SetTextI18n")
    override fun convert(helper: BaseViewHolder, item: VideoDetailPlayBean) {
        val context = helper.itemView.context
        val ivAvatar = helper.itemView.findViewById<ImageView>(R.id.ivCover)
        item.coverUrl?.let {
            ImageHelper.loadNet(
                context,
                ivAvatar,
                it,
                thumbnail = item.thumbnail ?: "",
                thumbScaleType = false
            )
        }
        helper.setText(R.id.tvSubject, item.title)

        // 作品的简介
        helper.getViewOrNull<AppCompatTextView>(R.id.tvTag)?.let {
            it.text = " ${SubjectHelper.getTypeStr(item.subjectType)}"
            it.setCompoundDrawablesWithIntrinsicBounds(
                getSubjectIconId(item.subjectType),
                0,
                0,
                0
            )
        }
    }

}