package com.transsion.search.bean

import android.os.Parcelable
import androidx.annotation.Keep
import com.transsion.moviedetailapi.bean.Group
import com.transsion.moviedetailapi.bean.Staff
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.fragment.result.ResultWrapData
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize

/**
 * Created by gaoxin.liu on 2025/3/18.
 * Description: 搜索结果v2
 */
@Keep
@Parcelize
data class SearchResultEntity(
    val pager: Pager,
    @IgnoredOnParcel
    var results: List<SearchList>? = null,
    var tabId: String? = null,
    var tabs: List<TabItem>? = null,
    var convertData: List<ResultWrapData>? = null
): Parcelable

@Keep
@Parcelize
data class TabItem(
    val tabId: String,
    val name: String,
    val subs: List<TabItem>
): Parcelable {
    @IgnoredOnParcel
    var isSelected = false
}

@Keep
data class SearchList(
    val topicType: String?,
    val title: String?,
    val showMore: Boolean?,
    val moreTabId: String?,
    val subjects: List<Subject>?, //作品
    val staffs: List<Staff>?,  // 演员
    val groups: List<Group>?, // 圈子
    val verticalRanks: List<VerticalRank>?, // 垂直榜单
)