package com.transsion.search.bean

import android.os.Parcelable
import androidx.annotation.Keep
import com.transsion.moviedetailapi.bean.Cover
import com.transsion.moviedetailapi.bean.Staff
import com.transsion.moviedetailapi.bean.Subject
import kotlinx.parcelize.Parcelize
import java.io.Serializable

/**
 * @author xinbing.zhang
 * @date :2023/2/8 19:46
 * @description: 搜索推荐返回的结果
 */
@Keep
@Parcelize
data class SearchSuggestEntity(
    var items: List<SuggestEntity>?, var keyword: String?, var ops: String?
) : Parcelable

/**
 * type: 对象类型(0:联想词 1:作品 2:垂类榜单 3:演员)
 */
@Keep
@Parcelize
data class SuggestEntity(
    var type: Int?,
    var word: String?,
    var verticalRank: VerticalRank?,
    var subject: Subject?,
    var staff: Staff?
) : Parcelable

/**
 * 垂类
 */
@Keep
@Parcelize
data class VerticalRank(
    var title: String?, var description: String?, var deeplink: String?, var cover: Cover?, var count: Int?
) : Parcelable, Serializable