package com.transsion.search.dialog

import android.os.Bundle
import android.text.TextUtils
import android.view.View
import android.widget.TextView
import com.transsion.baseui.dialog.BaseDialog
import com.transsion.search.R


class CheckTipsDialog : BaseDialog(R.layout.dialog_check) {


    companion object {
        fun newInstance(): CheckTipsDialog {
            return CheckTipsDialog()
        }
    }

    private var listener: CheckDialogListener? = null

    fun setListener(listener: CheckDialogListener) {
        this.listener = listener
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NORMAL, R.style.BaseDialogStyle)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initView(view)
    }

    private fun initView(view: View) {
        view.apply {
            findViewById<View>(R.id.btn_left)?.setOnClickListener {
                listener?.affirmDialogBtn()
                dismissAllowingStateLoss()
            }
            findViewById<View>(R.id.btn_yes)?.setOnClickListener { v ->
                listener?.cancelDialogBtn()
                dismissAllowingStateLoss()
            }

            if (!TextUtils.isEmpty(title)) {
                findViewById<TextView>(R.id.tv_tips)?.text = title
            }
            if (!TextUtils.isEmpty(btnLeft)) {
                findViewById<TextView>(R.id.btn_yes)?.text = btnLeft
            }
            if (!TextUtils.isEmpty(btnRight)) {
                findViewById<TextView>(R.id.btn_left)?.text = btnRight
            }
        }
    }

    private var title = ""
    private var btnLeft = ""
    private var btnRight = ""

    /**
     * 设置标题
     */
    fun setTitleTxt(title: String) {
        this.title = title
    }

    /**
     * 设置左边按钮
     */
    fun setLeftBtnTxt(btnLeft: String) {
        this.btnLeft = btnLeft
    }

    /**
     * 设置右边按钮
     */
    fun setRightBtnTxt(btnRight: String) {
        this.btnRight = btnRight
    }


}
