package com.transsion.search.fragment

import android.os.Bundle
import androidx.viewbinding.ViewBinding
import com.transsion.baseui.fragment.BaseFragment
import java.util.UUID

/**
 * Created by gaoxin.liu on 2025/3/24.
 * Description: 搜索三大主页面的父类
 */
abstract class BaseSearchMainFragment<T: ViewBinding> : BaseFragment<T>() {
    companion object {
        var sSearchId = ""
            private set

        /**
         * 每次进入搜索生成一个随机Id
         */
        fun resetSearchId() {
            sSearchId = UUID.randomUUID().toString()
        }
    }

    private var startTime: Long = 0
    private var isFirstPause = true

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        startTime = System.currentTimeMillis()
    }

    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)
        if (hidden) {
            //初次初始化时会默认调用一次hidden，避免触发上报
            if ((isFirstPause && System.currentTimeMillis() - startTime < 300).not()) {
                logPause()
            }
            isFirstPause = false

        } else {
            logResume()
        }
    }

    override fun logResume() {
        //避免误报
        if (!isHidden) {
            super.logResume()
        }
    }
}