package com.transsion.search.fragment.group

import android.annotation.SuppressLint
import android.net.Network
import android.net.NetworkCapabilities
import android.os.Bundle
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.Gravity
import android.view.KeyEvent
import android.view.LayoutInflater
import android.view.View
import android.view.inputmethod.EditorInfo
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.view.isVisible
import androidx.fragment.app.viewModels
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.OnScrollListener
import com.blankj.utilcode.util.KeyboardUtils
import com.tn.lib.ext.gone
import com.tn.lib.ext.visible
import com.tn.lib.util.networkinfo.NetworkUtil
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener
import com.tn.lib.widget.toast.TRToast
import com.tn.lib.widget.toast.core.ToastUtils
import com.transsion.baselib.helper.DataHelper
import com.transsion.baselib.report.LogViewConfig
import com.transsion.baseui.fragment.BaseFragment
import com.transsion.baseui.recycler.LoadMoreOnScrollListener
import com.transsion.publish.api.OperationMenu
import com.transsion.search.R
import com.transsion.search.SearchManager
import com.transsion.search.bean.BackEntity
import com.transsion.search.constant.Constant
import com.transsion.search.constant.SearchConstants
import com.transsion.search.databinding.FragmentPublishWorkBinding
import com.transsion.search.fragment.group.adapter.SearchWorkHistoryAdapter
import com.transsion.search.viewmodel.SearchWorkViewModel
import com.transsnet.flow.event.postEvent

/**
 *  发帖用搜索  可搜作品
 */
class SearchUploadWorkFragment : BaseFragment<FragmentPublishWorkBinding>() {

    private var isRefreshing: Boolean = false
    private var mSearchWorkAdapter: SearchWorkRecentAdapter? = null
    private var mHistoryAdapter: SearchWorkHistoryAdapter? = null
    private val mViewModel: SearchWorkViewModel by viewModels()

    private var mSearchViewModel: com.transsion.search.viewmodel.SearchViewModel? = null
    private var mType: Int = 0
    private var page: Int = 1
    private var perPage: Int = 10

    private var mKeyword: String = ""

    override fun getViewBinding(inflater: LayoutInflater): FragmentPublishWorkBinding {
        return FragmentPublishWorkBinding.inflate(inflater)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        mType = arguments?.getInt("type") ?: SearchConstants.SEARCH_WORK
        mSearchWorkAdapter = SearchWorkRecentAdapter(mutableListOf()).apply {
            loadMoreModule.setOnLoadMoreListener {
                if (NetworkUtil.hasCapabilityAsync()) {
                    mSearchViewModel?.searchWork(page, perPage, mKeyword)
                } else {
                    TRToast.show(com.tn.lib.widget.R.string.no_network_toast)
                    mViewBinding?.rv?.postDelayed({
                        mSearchWorkAdapter?.loadMoreModule?.loadMoreFail()
                    }, 300)
                }
            }

            setOnItemClickListener { _, view, position ->
                mSearchWorkAdapter?.data?.get(position)?.let {
                    reportClick("", it.subjectId, it.ops, position)
                    val operation = OperationMenu()
                    operation.item_type = Constant.ITEM_WORKS
                    operation.item_operation = Constant.OPERATION_ADD
                    operation.subject = it
                    postEvent(operation)
                    activity?.finish()
                }
            }
        }
        initHistory()
        mViewBinding?.let { binding ->
            binding.rv.layoutManager =
                LinearLayoutManager(requireContext(), LinearLayoutManager.VERTICAL, false)
            binding.rv.adapter = mHistoryAdapter
            binding.rv.addOnScrollListener(LoadMoreOnScrollListener(mSearchWorkAdapter?.loadMoreModule))
            binding.rv.addOnScrollListener(LoadMoreOnScrollListener(mHistoryAdapter?.loadMoreModule))
            initViewModel()
            binding.inputET.setOnFocusChangeListener { view, hasFocus ->
                view.dispatchWindowFocusChanged(hasFocus)
            }
            binding.searchTV.setOnClickListener {
                searchJob()
            }
            binding.inputET.addTextChangedListener(object : TextWatcher {
                override fun beforeTextChanged(
                    s: CharSequence?,
                    start: Int,
                    count: Int,
                    after: Int
                ) {
                    searchShow(true)
                }

                override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
                }

                override fun afterTextChanged(s: Editable?) {
                    if ((s?.length ?: 0) == 0) {
                        resetContent(true)
                    }
                    mKeyword = s.toString().trim()
                }
            })
            binding.inputET.setOnEditorActionListener(object :
                TextView.OnEditorActionListener {
                override fun onEditorAction(tv: TextView?, i: Int, keyEvent: KeyEvent?): Boolean {
                    if (i == EditorInfo.IME_ACTION_SEARCH || i == EditorInfo.IME_ACTION_UNSPECIFIED) {
                        mKeyword = tv?.text.toString().trim()
                        searchJob()
                        return true
                    }
                    return false
                }

            })
            binding.clearIV.setOnClickListener {
                resetContent(false)
            }
            binding.loadView.gone()
            binding.ivCancel.setOnClickListener {
                postFinish()
                activity?.finish()
            }
            binding.inputET.requestFocus()
            binding.inputET.let { KeyboardUtils.showSoftInput(it) }
            logViewConfig?.isLoadSuccess = true

            binding.rv.addOnScrollListener(object : OnScrollListener() {
                override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                    super.onScrollStateChanged(recyclerView, newState)
                    if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                        activity?.apply {
                            if (KeyboardUtils.isSoftInputVisible(this)) {
                                binding.inputET.let { KeyboardUtils.hideSoftInput(it) }
                            }
                        }
                    }
                }
            })
        }
    }

    private fun initHistory() {
        mHistoryAdapter = SearchWorkHistoryAdapter(mutableListOf()).apply {
            loadMoreModule.setOnLoadMoreListener {
                if (!mViewModel.hasMore) {
                    loadMoreModule.loadMoreEnd(false)
                } else {
                    mViewModel.getVideoHistoryList()
                }
            }

            setOnItemClickListener { _, view, position ->
                mHistoryAdapter?.data?.get(position)?.let {
                    reportClick("", it.subjectId, "", position)
                    val operation = OperationMenu().apply {
                        item_type = Constant.ITEM_WORKS
                        item_operation = Constant.OPERATION_ADD
                    }.setSubjectData(
                        subjectId = it.subjectId,
                        subjectType = it.subjectType,
                        title = it.title,
                        coverUrl = it.coverUrl,
                        thumbnail = it.thumbnail
                    )
                    postEvent(operation)
                    activity?.finish()
                }
            }
        }
    }

    private fun getHistoryWork() {
        mViewModel.getVideoHistoryList(true)
        mViewModel.historyData.observe(this) {
            if (it.isNullOrEmpty()) {
                mViewBinding?.recentTV?.gone()
            }
            mHistoryAdapter?.setList(it)
        }
    }

    override fun initView(view: View, savedInstanceState: Bundle?) {
        netListener = object : OnNetworkStatusChangedListener {
            override fun onDisconnected() {}
            override fun onConnected(network: Network, networkCapabilities: NetworkCapabilities) {
                if (mSearchWorkAdapter?.data?.isEmpty() == true) {
                    searchJob()
                } else {
                    mSearchWorkAdapter?.loadMoreModule?.loadMoreToLoading()
                }
            }
        }
    }

    private fun resetContent(clear: Boolean) {
        if (!clear) {
            mViewBinding?.inputET?.setText("")
            mKeyword = ""
        }
        mSearchWorkAdapter?.setNewInstance(mutableListOf())
        mSearchWorkAdapter?.removeEmptyView()
        // 展示历史记录
        mViewBinding?.let { binding ->
            switchStatus(true)
            binding.recentTV.isVisible = mHistoryAdapter?.data.isNullOrEmpty().not()
            binding.inputET.let { inputET -> KeyboardUtils.showSoftInput(inputET) }
        }
    }

    private fun postFinish() {
        postEvent(BackEntity())
    }

    private fun searchJob() {
        if (TextUtils.isEmpty(mKeyword)) {
            ToastUtils.setGravity(Gravity.CENTER_VERTICAL)
            ToastUtils.show(getString(R.string.tips_movie))
            return
        }
        isRefreshing = true
        SearchManager.INSTANCE.addSearch(mKeyword)
        KeyboardUtils.hideSoftInput(mViewBinding?.inputET!!)
        if (!NetworkUtil.hasCapabilityAsync()) {
            showNoNet()
            return
        }
        mViewBinding?.loadView?.visible()
        searchShow(false)
        page = 1
        mSearchViewModel?.searchWork(page, perPage, mKeyword)
        val map = HashMap<String, String>()
        map["module_name"] = "search"
        map["key_word"] = mKeyword
        map["type"] = mType.toString()
        DataHelper.reportFeedClickEvent("searchpage", map)
    }

    @SuppressLint("InflateParams")
    private fun initViewModel() {
        mSearchViewModel =
            ViewModelProvider(requireActivity())[com.transsion.search.viewmodel.SearchViewModel::class.java].apply {
                getSearchGroupLiveData().observe(this@SearchUploadWorkFragment.viewLifecycleOwner) {
                    page = it?.pager?.nextPage?.toIntOrNull() ?: 1
                    perPage = it?.pager?.perPage ?: 10
                    mViewBinding?.loadView?.gone()
                }
                getSearchWorkLiveData().observe(this@SearchUploadWorkFragment.viewLifecycleOwner) {
                    //过滤掉关联作品中的H5端外作品
                    val dataList = it?.items?.filter { item -> !item.isJumpBrowser() }
                    val hasMore = it?.pager?.hasMore ?: false
                    page = it?.pager?.nextPage ?: 1
                    perPage = it?.pager?.perPage ?: 10
                    mViewBinding?.loadView?.gone()
                    mSearchWorkAdapter?.apply {
                        loadMoreModule.loadMoreComplete()
                        val empty = mSearchWorkAdapter?.data?.isEmpty()
                        if (dataList.isNullOrEmpty() && empty == true && (page == 1 || it?.pager?.page == 1)) {
                            setNewInstance(mutableListOf())
                            setEmptyView(emptyView())
                            switchStatus(false)
                            isUseEmpty = true
                        }
                        if (!dataList.isNullOrEmpty()) {
                            if (isRefreshing) {
                                isRefreshing = false
                                mSearchWorkAdapter?.setList(dataList)
                            } else {
                                mSearchWorkAdapter?.addData(dataList)
                            }
                            logViewConfig?.isLoadSuccess = true
                            logViewConfig?.paramsMap?.set("type", mType.toString())
                            // 替换adapter
                            switchStatus(false)
                        } else {
                            loadMoreModule.loadMoreEnd(false)
                        }
                        if (!hasMore) {
                            loadMoreModule.loadMoreEnd(false)
                        }
                        if (null == it) {
                            loadMoreModule.loadMoreFail()
                        }
                    }
                }
            }
    }

    override fun lazyLoadData() {
        getHistoryWork()
    }

    private fun emptyView(): View {
        val view =
            layoutInflater.inflate(R.layout.view_search_manager_empty, null)
        val emptyTipsView = view.findViewById<TextView>(R.id.tv_empty_tips)
        val imageView = view.findViewById<ImageView>(R.id.iv_tips)
        val retryBtn = view.findViewById<AppCompatTextView>(R.id.tv_retry)
        if (NetworkUtil.hasCapabilityAsync()) {
            //emptyTipsView.setText(if (mType ==  SearchConstants.SEARCH_GROUP) R.string.user_follower_empty else R.string.user_works_empty)
            val keyword = mViewBinding?.inputET?.text.toString()
            emptyTipsView.text = getString(R.string.user_works_empty) + " \"" + keyword + "\""
            retryBtn.visibility = View.GONE
            imageView.setImageResource(com.tn.lib.widget.R.mipmap.ic_no_content)
        } else {
            emptyTipsView.setText(com.transsion.baseui.R.string.base_network_fail)
            imageView.setImageResource(com.tn.lib.widget.R.mipmap.ic_no_network)
            retryBtn.visibility = View.VISIBLE
            retryBtn.setOnClickListener {
                searchJob()
            }
        }
        return view
    }

    override fun onDestroyView() {
        mViewBinding?.loadView?.gone()
        super.onDestroyView()
    }

    /* 切换显示状态 */
    private fun switchStatus(showHistory: Boolean) {
        mViewBinding?.let { binding ->
            binding.recentTV.isVisible = showHistory
            if (showHistory) {
                binding.rv.adapter = mHistoryAdapter
                mHistoryAdapter?.setList(mViewModel.historyData.value)
            } else {
                binding.rv.adapter = mSearchWorkAdapter
            }
        }
    }

    /* 控制搜索按钮展示 */
    private fun searchShow(show: Boolean) {
        mViewBinding?.let {
            if (show) {
                it.searchTV.visible()
                it.clearIV.gone()
            } else {
                it.searchTV.gone()
                it.clearIV.visible()
            }
        }
    }

    /* 展示无网状态 */
    private fun showNoNet() {
        TRToast.show(com.tn.lib.widget.R.string.no_network_toast)
        switchStatus(false)
        mSearchWorkAdapter?.setEmptyView(emptyView())
        mSearchWorkAdapter?.setNewInstance(mutableListOf())
    }

    private fun reportClick(group_id: String?, subject_id: String?, opt: String?, position: Int) {
        val map = HashMap<String, String>()
        map["group_id"] = group_id ?: ""
        map["subject_id"] = subject_id ?: ""
        map["sequence"] = position.toString()
        map["ops"] = opt ?: ""

        DataHelper.reportFeedClickEvent("searchresult", map)
    }

    override fun newLogViewConfig(): LogViewConfig {
        return LogViewConfig("searchpage")
    }

    companion object {
        fun newInstance(type: Int): SearchUploadWorkFragment {
            val fragment = SearchUploadWorkFragment()
            val bundle = Bundle()
            bundle.putInt("type", type)
            fragment.arguments = bundle
            return fragment
        }
    }
}