package com.transsion.search.fragment.group

import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.transsion.baselib.helper.DataHelper
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.adapter.provider.SearchRoomWorkProvider
import com.transsion.search.bean.SearchSubject

class SearchWorkRecentAdapter(datas: MutableList<SearchSubject>) :
    BaseProviderMultiAdapter<SearchSubject>(datas), LoadMoreModule {

    companion object {

        //串联搜索点击，item曝光，item点击 埋点的id
        var trid = ""
        fun report(item: Subject, sequence: Int) {
            val map = HashMap<String, String>()
            map["subject_id"] = item.subjectId ?: ""
            map["has_resource"] = item.hasResource.toString()
            map["ops"] = item.ops ?: ""
            map["sequence"] = sequence.toString()
            if (trid.isNotEmpty()) {
                map["trid"] = trid
            }
            DataHelper.reportBrowseEvent("searchresult", map)
        }
    }

    init {
        addItemProvider(SearchRoomWorkProvider())
    }
    override fun getItemType(data: List<SearchSubject>, position: Int): Int {
        return data[position].viewType
    }


}