package com.transsion.search.fragment.hot

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.tn.lib.decoration.SimpleItemDecoration
import com.tn.lib.view.layoutmanager.NpaGridLayoutManager
import com.transsion.baselib.utils.DeviceInfo
import com.transsion.baseui.fragment.BaseFragment
import com.transsion.search.R
import com.transsion.search.bean.HotRankItem
import com.transsion.search.databinding.FragmentSearchRankPagerBinding
import com.transsion.search.fragment.hot.adapter.SearchCommunityAdapter
import com.transsion.search.fragment.hot.adapter.SearchRankItemAdapter
import com.transsion.search.isTablet
import com.transsion.search.widget.SearchReportHelper

/**
 * Created by gaoxin.liu on 2024/9/20.
 * Description:
 */
class SearchRankPagerFragment : BaseFragment<FragmentSearchRankPagerBinding>() {
    companion object {
        fun newInstance(hotRankItem: HotRankItem?): SearchRankPagerFragment {
            val args = Bundle()
            args.putParcelable("hotRankItem", hotRankItem)

            val fragment = SearchRankPagerFragment()
            fragment.arguments = args
            return fragment
        }
    }

    private var hasReported = false

    override fun getViewBinding(inflater: LayoutInflater): FragmentSearchRankPagerBinding {
        return FragmentSearchRankPagerBinding.inflate(inflater)
    }

    override fun initView(view: View, savedInstanceState: Bundle?) {
        val hotRankItem = arguments?.getParcelable("hotRankItem") as? HotRankItem?
        hotRankItem?:return

        val isGroupTab = hotRankItem.category == HotRankItem.CATE_GROUP
        if (!isGroupTab && hotRankItem.items.isNullOrEmpty() || isGroupTab && hotRankItem.groups.isNullOrEmpty()) {
            return
        }

        mViewBinding?.searchRankPagerType?.setImageResource(when(hotRankItem.category){
            HotRankItem.CATE_MOVIE -> R.drawable.rank_type_movie
            HotRankItem.CATE_MUSIC -> R.drawable.rank_type_music
            HotRankItem.CATE_TV -> R.drawable.rank_type_tv
            else -> R.drawable.rank_type_community
        })
        mViewBinding?.searchRankPagerRecycler?.apply {
            val isTablet = isTablet(resources)
            layoutManager = if (isTablet) {
                NpaGridLayoutManager(context, 2)
            } else {
                LinearLayoutManager(context)
            }

            if (hotRankItem.category != HotRankItem.CATE_TV
                &&  hotRankItem.category != HotRankItem.CATE_MOVIE
                && itemDecorationCount == 0) {
                addItemDecoration(SimpleItemDecoration(verticalMargin = 8f))
            }

            adapter = if (isGroupTab) {
                SearchCommunityAdapter(hotRankItem.category, hotRankItem.index).apply {
                    setList(hotRankItem.groups)
                }
            } else {
                SearchRankItemAdapter(hotRankItem.category, hotRankItem.index, isTablet).apply {
                    setList(hotRankItem.items)
                }
            }
        }
    }

    fun onPageSelected() {
        if (hasReported.not()) {
            val mIsLowDevice: Boolean = DeviceInfo.lowMemoryDevice()
            val hotRankItem = arguments?.getParcelable("hotRankItem") as? HotRankItem?
            hotRankItem?.items?.forEachIndexed { index, subject ->
                SearchReportHelper.reportRankSubjectBrowse(subject, index,
                    hotRankItem.category, hotRankItem.index, mIsLowDevice)
            }

            hotRankItem?.groups?.forEachIndexed { index, groupInfo ->
                SearchReportHelper.reportRankGroupBrowse(groupInfo, index,
                    hotRankItem.category, hotRankItem.index, mIsLowDevice)
            }
            hasReported = true
        }
    }




    override fun lazyLoadData() {

    }
}