package com.transsion.search.fragment.hot.adapter

import android.app.Activity
import android.text.SpannableStringBuilder
import androidx.constraintlayout.widget.ConstraintLayout
import com.alibaba.android.arouter.launcher.ARouter
import com.blankj.utilcode.util.KeyboardUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.android.material.imageview.ShapeableImageView
import com.tn.lib.utils.ScreenUtils
import com.transsion.baselib.utils.DeviceInfo
import com.transsion.baselib.utils.formatNumberKM
import com.transsion.baseui.image.ImageHelper
import com.transsion.room.api.RoomConstants
import com.transsion.room.api.RoomPageIdentity
import com.transsion.search.R
import com.transsion.search.bean.GroupInfo
import com.transsion.search.getResultSplitSpan
import com.transsion.search.widget.SearchReportHelper

/**
 * Created by gaoxin.liu on 2024/5/20.
 * Description: 搜索首页热榜子view
 */
class SearchCommunityAdapter(
    private val parentCategory: String,
    private val parentIndex: Int
) : BaseQuickAdapter<GroupInfo, BaseViewHolder>(R.layout.provider_result_group), LoadMoreModule {

    private val mIsLowDevice: Boolean = DeviceInfo.lowMemoryDevice()

    override fun convert(holder: BaseViewHolder, item: GroupInfo) {
        // 封面
        val cover = holder.getView<ShapeableImageView>(R.id.search_result_provider_group_cover).apply {
            val lp = this.layoutParams as ConstraintLayout.LayoutParams
            lp.marginStart = ScreenUtils.dpToPx(this.context, 12f)
            layoutParams = lp
        }
        ImageHelper.loadNet(
            context,
            cover,
            item.cover.url ?: "",
            thumbnail = item.cover.thumbnail?: ""
        )
        val position = getItemPosition(item)

        val bgRes = when (position) {
            0 -> R.drawable.bg_hot_subject_no1
            1 -> R.drawable.bg_hot_subject_no2
            2 -> R.drawable.bg_hot_subject_no3
            else ->  R.drawable.bg_hot_subject_no4
        }
        holder.setVisible(R.id.search_result_provider_group_index_text, true)
        holder.setBackgroundResource(R.id.search_result_provider_group_index_text, bgRes)
        holder.setText(R.id.search_result_provider_group_index_text, (position + 1).toString())
        //标题
        holder.setText(R.id.search_result_provider_group_title,  item.name)

        //人数
        val userCountStr = item.userCount?.formatNumberKM()
        val memberStr = context.getString(com.tn.lib.widget.R.string.members, userCountStr?:"0")
        holder.setText(R.id.search_result_provider_group_member, memberStr)

        //tag
        val sb = SpannableStringBuilder()
        item.tags?.forEachIndexed { index, tag ->
            sb.append(tag)
            if (index < (item.tags?.size ?: 0) - 1) {
                sb.append("\uFFFC")
                sb.setSpan(
                    getResultSplitSpan(context), sb.length - 1, sb.length,
                    SpannableStringBuilder.SPAN_EXCLUSIVE_EXCLUSIVE)
            }
        }
        if (sb.isNotEmpty()) {
            holder.setText(R.id.search_result_provider_group_des,  sb)
            holder.setVisible(R.id.search_result_provider_group_des, true)
        } else {
            holder.setGone(R.id.search_result_provider_group_des, true)
        }

        holder.setVisible(R.id.search_result_provider_group_arrow,false)
        holder.itemView.setOnClickListener {
            onItemClick(item)
        }
    }

    private fun onItemClick(groupInfo: GroupInfo) {
        SearchReportHelper.reportRankGroupClick(groupInfo, getItemPosition(groupInfo), parentCategory, parentIndex, mIsLowDevice)

        if (context is Activity) {
            if (KeyboardUtils.isSoftInputVisible(context as Activity)) {
                KeyboardUtils.hideSoftInput(context as Activity)
            }
        }

        ARouter.getInstance().build(RoomPageIdentity.ROOM_DETAIL)
            .withString(RoomConstants.FIELD_ID, groupInfo.groupId)
            .navigation()
    }
}