package com.transsion.search.fragment.hot.adapter

import android.annotation.SuppressLint
import android.util.Log
import android.view.View
import android.widget.ImageView
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.android.flexbox.FlexboxLayoutManager
import com.transsion.search.R
import com.transsion.search.widget.LinesFlexBoxLayoutManager
import com.transsion.search.widget.SearchReportHelper

/**
 * Created by gaoxin.liu on 2024/5/17.
 * Description:
 */
data class HistoryVal(
    val type: Int,
    val strVal: String
)

class SearchHistoryAdapter : BaseProviderMultiAdapter<HistoryVal>(), LoadMoreModule {
    init {
        addItemProvider(HistoryProvider())
    }

    private var listener: (() -> Unit)? = null

    fun setMoreClickListener(listener: () -> Unit) {
        this.listener = listener
    }

    private var showMode:Boolean = false
    private var expandMode:Boolean = false
    private var showMoreIndex: Int = -1
    @SuppressLint("Range")
    fun setShowMoreMode(moreShow: Boolean, isExpand: Boolean, moreIndex: Int = -1) {
        Log.d("qqqq", "setShowMoreMode, moreShow:$moreShow, isExpand:$isExpand,  moreIndex:$moreIndex")
        showMode = moreShow
        expandMode = isExpand
        showMoreIndex = moreIndex

        if (itemCount <= 0) return
        if (moreIndex < 0) return

        //埋点暂在此上报，调整历史词渲染调用逻辑需注意
        val browseEnd = if (moreShow) (moreIndex + 1) else itemCount
        for (i in 0 until browseEnd) {
            if (i < itemCount) {
                SearchReportHelper.reportHistoryWordBrowse(getItem(i).strVal, i)
            }
        }
    }

    override fun getItemType(data: List<HistoryVal>, position: Int): Int {
        return data[position].type
    }

    companion object {
        const val TYPE_HISTORY_VAL = 1
        const val TYPE_HISTORY_MORE = 2
    }

    inner class HistoryProvider : BaseItemProvider<HistoryVal>() {
        override val itemViewType: Int
            get() = TYPE_HISTORY_VAL

        override val layoutId: Int
            get() = R.layout.item_search_history_word

        override fun convert(helper: BaseViewHolder, item: HistoryVal) {
            val position = getItemPosition(item)
            helper.setText(R.id.search_history_text, item.strVal)

            val showArrow = (showMode && position == showMoreIndex)
//            val layoutManager = recyclerView.layoutManager as LinesFlexBoxLayoutManager
//            //lines == 0代表是预测量的时候
//            val lines = layoutManager.getActualLineCount()
//            val arrowVisible = if (showArrow) {
//                View.VISIBLE
//            } else if (lines == 0) {
//                View.INVISIBLE
//            } else {
//                View.GONE
//            }

            helper.getView<ImageView>(R.id.search_hot_history_more_image).apply {
                visibility = if (showArrow) View.VISIBLE else View.GONE
                setImageResource(if (expandMode) R.drawable.ic_hide else R.drawable.ic_more)
                setOnClickListener {
                    if (showMode && position == showMoreIndex) {
                        listener?.invoke()
                        SearchReportHelper.reportHistoryExpandClick(!expandMode)
                    }
                }
            }
        }
    }
}




