package com.transsion.search.fragment.suggest.provider

import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.search.R
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.fragment.suggest.SearchSuggestMultiAdapter

/**
 * @author xinbing.zhang
 * @date :2023/3/23 14:06
 * @description: 文案展示
 */
class SearchSuggestCopyWritingProvider : BaseItemProvider<SuggestEntity>() {

    override val itemViewType: Int
        get() = SearchSuggestMultiAdapter.SEARCH_SUGGEST_PROVIDER_COPY_WRITING

    override val layoutId: Int
        get() = R.layout.fragment_search_suggest_copy_writing_layout

    override fun convert(helper: BaseViewHolder, item: SuggestEntity) {
        helper.setText(R.id.tvSearchSuggest,
            SearchSuggestMultiAdapter.highlight(
                (getAdapter() as? SearchSuggestMultiAdapter)?.mKeyWord ?: "", item.word
            )
        )
    }
}