package com.transsion.search.fragment.suggest.provider

import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.bean.SuggestEntity
import com.transsion.search.fragment.suggest.SearchSuggestMultiAdapter

/**
 * @author xinbing.zhang
 * @date :2023/3/23 14:06
 * @description: 展示封面类型的
 */
class SearchSuggestListCoverProvider : BaseItemProvider<SuggestEntity>() {

    override val itemViewType: Int
        get() = SearchSuggestMultiAdapter.SEARCH_SUGGEST_PROVIDER_LIST_COVER

    override val layoutId: Int
        get() = R.layout.fragment_search_suggest_list_cover_layout

    override fun convert(helper: BaseViewHolder, item: SuggestEntity) {
        // 封面展示
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.ivCover),
            item.verticalRank?.cover?.url ?: "",
            placeHolder = R.drawable.ic_list_cover
        )

        helper.setText(
            R.id.tvTitle, SearchSuggestMultiAdapter.highlight(
                (getAdapter() as? SearchSuggestMultiAdapter)?.mKeyWord ?: "",
                item.verticalRank?.title
            )
        )
        helper.setText(R.id.tvDes, item.verticalRank?.description)
    }

}