package com.transsion.search.fragment.values.adapter

import android.content.Context
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.transsion.search.adapter.provider.SearchAssociationProvider
import com.transsion.search.adapter.provider.SearchWorkProvider
import com.transsion.search.bean.SearchSubject

/**
 * @author xinbing.zhang
 * @date :2023/8/17 16:18
 * @description: 纵向列表 作品
 */
class SearchResultSubjectAdapter(context: Context) : BaseProviderMultiAdapter<SearchSubject>(), LoadMoreModule {

    init {
        addItemProvider(SearchWorkProvider(context))
        addItemProvider(SearchAssociationProvider())

    }

    override fun getItemType(data: List<SearchSubject>, position: Int): Int {
        return data[position].viewType
    }
}