package com.transsion.search.fragment.values.adapter

import android.os.Build
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.DynamicDrawableSpan
import android.text.style.ImageSpan
import androidx.appcompat.widget.AppCompatTextView
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.search.R
import com.transsion.search.bean.SearchValuesRelatedCollectionEntity
import com.transsion.search.fragment.values.SearchValuesFragment
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_STAFF

/**
 * @author xinbing.zhang
 * @date :2023/9/12 20:42
 * @description: 演员
 */
class SearchValuesRelatedCollectionStaffProvider :
    BaseItemProvider<SearchValuesRelatedCollectionEntity>() {

    override val itemViewType: Int
        get() = SEARCH_VALUES_RANK_TYPE_STAFF

    override val layoutId: Int
        get() = R.layout.item_search_values_staff_layout

    override fun convert(helper: BaseViewHolder, item: SearchValuesRelatedCollectionEntity) {
        // 封面
        ImageHelper.loadNet(
            context,
            helper.getView(R.id.ivCover),
            item.staff?.avatarUrl ?: "",
            placeHolder = com.transsion.moviedetailapi.R.mipmap.movie_staff_default_avatar
        )
        // 标题
        helper.setText(
            R.id.tvTitle,  item.staff?.name)

        helper.getViewOrNull<AppCompatTextView>(R.id.tvDes)?.apply {
            val sb = SpannableStringBuilder()
            item.staff?.staffTypes?.let {
                it.forEachIndexed { index, staffTypes ->
                    sb.append("${staffTypes.name}")
                    if (index < it.size - 1) {
                        sb.append(" · ")
                    }
                }
            }
            val span = SpannableStringBuilder()
            span.append("  ")
            span.append(sb.toString())
            val subjectImageId = R.drawable.search_suggest_staff
            val imageSpan: ImageSpan = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_CENTER)
            } else {
                ImageSpan(context, subjectImageId, DynamicDrawableSpan.ALIGN_BASELINE)
            }
            span.setSpan(imageSpan, 0, 1, Spannable.SPAN_EXCLUSIVE_INCLUSIVE)
            text = span
        }

        // 参演数量
        helper.setText(
            R.id.tvWorks, "${item.staff?.subjectNum} ${context.getString(R.string.search_works)}"
        )

        // 曝光
        SearchValuesFragment.reportShow(
            group_id = "",
            subject_id = "",
            staffId = item.staff?.staffId,
            ops = "",
            position = helper.bindingAdapterPosition,
            SEARCH_VALUES_RANK_TYPE_STAFF
        )
    }

    private fun getKeyWord(): String {
        return (getAdapter() as? SearchValuesRelatedCollectionAdapter)?.getKeyWord() ?: ""
    }
}