package com.transsion.search.fragment.values.adapter

import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.search.R
import com.transsion.search.bean.SearchValuesRelatedCollectionEntity
import com.transsion.search.fragment.values.SearchValuesFragment.Companion.SEARCH_VALUES_RANK_TYPE_TITLE

/**
 * @author xinbing.zhang
 * @date :2023/9/12 20:42
 * @description: 标题
 */
class SearchValuesRelatedCollectionTitleProvider :
    BaseItemProvider<SearchValuesRelatedCollectionEntity>() {

    override val itemViewType: Int
        get() = SEARCH_VALUES_RANK_TYPE_TITLE

    override val layoutId: Int
        get() = R.layout.item_search_values_title_layout

    override fun convert(helper: BaseViewHolder, item: SearchValuesRelatedCollectionEntity) {
        helper.setText(R.id.tvTopTitle, item.title)
    }
}