package com.transsion.search.fragment.values.adapter

import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import androidx.fragment.app.FragmentTransaction
import androidx.viewpager2.adapter.FragmentStateAdapter
import com.transsion.search.bean.Count
import com.transsion.search.bean.SearchWorkEntity
import com.transsion.search.fragment.values.SearchValuesTypeFragment


/**
 * @author xinbing.zhang
 * @date :2023/8/23 16:41
 * @description:
 */
class SearchValuesTypeFragmentAdapter(
    val fragment: Fragment,
    val count: List<Count>,
    val mKeyWord: String,
    val mEntity: SearchWorkEntity?,
    val mType: Int
) : FragmentStateAdapter(fragment) {

    private var mCurTransaction: FragmentTransaction? = null
    private var mFragmentManger: FragmentManager? = null
    private val mFragmentList = mutableListOf<SearchValuesTypeFragment>()

    init {
        count.forEach {
            val newInstance = SearchValuesTypeFragment.newInstance(it, mKeyWord, mType)
            newInstance.setSearchWorkEntity(entity = mEntity)
            mFragmentList.add(newInstance)
        }
    }

    override fun getItemCount(): Int = mFragmentList.size

    override fun createFragment(position: Int): Fragment {
        return mFragmentList[position]
    }

    /**
     * 清除缓存fragment
     * https://blog.csdn.net/chuyouyinghe/article/details/130843669
     */
    fun clear() {
        kotlin.runCatching {
            // 销毁Fragment内部的数据
            mFragmentList.forEach {
                it.onDestroy()
            }
            mFragmentList.clear()
            notifyDataSetChanged()

            // 销毁ViewPager关联的Fragment
            if (this.mCurTransaction == null) {
                mFragmentManger = fragment.childFragmentManager
                this.mCurTransaction = mFragmentManger?.beginTransaction()
            }

            mFragmentManger?.fragments?.let {
                if (it.isNotEmpty()) {
                    it.forEach { fragment ->
                        (fragment as? SearchValuesTypeFragment)?.let { typeFragment ->
                            mCurTransaction?.remove(typeFragment)
                        }
                    }
                }
            }
            mCurTransaction?.commitNowAllowingStateLoss()
        }
    }
}