package com.transsion.search.speech

import java.util.LinkedList

/**
 * @author: zhangxinbing
 * @date : 2024/10/11 16:14
 * @description: 固定容量的容器
 */
class FixedSizeList<T>(private val maxSize: Int = 10) {

    private val list: LinkedList<T> = LinkedList()

    fun add(element: T) {
        if (list.size == maxSize) {
            list.removeFirst() // 移除最早的元素
        }
        list.addLast(element)
    }

    fun getLinkedList(): LinkedList<T> {
        return list
    }

    /**
     * 容器装满了
     */
    fun isFillUp(): Boolean = list.size == maxSize

    fun clear(){
        list.clear()
    }

    override fun toString(): String {
        return list.toString()
    }

}
