package com.transsion.search.speech

import android.content.Intent
import android.net.Uri
import android.os.Build
import android.provider.Settings
import android.speech.SpeechRecognizer
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import com.blankj.utilcode.util.Utils

/**
 * @author: zhangxinbing
 * @date : 2024/10/11 20:19
 * @description: 语音是被工具
 */
object SRUtil {

    /**
     * 用来判断设备是否支持离线语音识别。
     *
     * 具体来说，它检查设备是否能够在没有网络连接的情况下进行语音识别。
     * 如果返回true，表示设备支持离线识别；如果返回false，则表示需要网络连接来进行语音识别。
     */
    @RequiresApi(Build.VERSION_CODES.S)
    fun isOnDeviceRecognitionAvailable(): Boolean {
        return SpeechRecognizer.isOnDeviceRecognitionAvailable(Utils.getApp())
    }

    /**
     * 是用来判断设备上是否支持语音识别功能的。
     *
     * 具体来说，它会检查设备是否具有必要的硬件和软件支持来进行语音识别。
     * 如果返回true，表示设备支持语音识别；如果返回false，则表示不支持。
     * 这样可以在应用中根据设备的支持情况来决定是否启用语音识别功能。
     */
    fun isRecognitionAvailable(): Boolean {
        return SpeechRecognizer.isRecognitionAvailable(Utils.getApp())
    }

    /**
     * 打开权限设置页面
     *
     * 目前 Android 系统并不支持直接跳转到具体权限的设置页面，只能跳转到应用的详情设置页面，然后用户需要手动进入“权限”设置页面进行授权操作。
     * 这个方法将打开应用的详细信息页面，用户可以在这个页面中点击“权限”来管理应用的权限，不过这仍然需要用户手动点击权限管理的选项。
     */
    fun openThePermissionSettingsPage(activity: AppCompatActivity) {
        val intent = Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS)
        val uri = Uri.fromParts("package", activity.packageName, null)
        intent.setData(uri)
        activity.startActivity(intent)
    }

}