package com.transsion.search.speech

/**
 * @author: zhangxinbing
 * @date : 2024/10/11 16:50
 * @description: 语音识别 音量策略
 */
class VolumeStrategy {

    private var mCallback: (() -> Unit?)? = null

    private var timestamp = 0L

    private val volumeList = FixedSizeList<Float>(10)

    private fun getClassTag(): String = javaClass.simpleName

    companion object {
        private const val ADD_INTERVAL_TIME = 200
        private const val MAX_MIN_VOLUME_GAP = 6f
        private const val MIN_VOLUME = 3f
    }


    // =============================================================================================


    fun destroy() {
        mCallback = null
        timestamp = 0L
        volumeList.clear()
    }

    fun setCallback(callback: (() -> Unit?)? = null) {
        mCallback = callback
    }

    /**
     * TODO 声音都小于一个值的时候，延迟退出
     */
    fun onVolumeChange(rmsdB: Float) {
        // 间隔XXX毫秒添加一个数据到固定数量的容器里面
        // 当前音量变化超过一定量之后，就可以判断当前没有语音输入了
        if ((System.currentTimeMillis() - timestamp) > ADD_INTERVAL_TIME) {
            timestamp = System.currentTimeMillis()
            volumeList.add(rmsdB)
            SRLogger.logD("${getClassTag()} --> onVolumeChange() --> volumeList = $volumeList")

            // 最大值和最小值差值判断 --> 意味着这里最小输入语音需要达到 (DEFAULT_INTERVAL_TIME * DEFAULT_VOLUME_GAP) 毫秒时间
            if (volumeList.isFillUp()) {
                val maxOrNull = volumeList.getLinkedList().maxOrNull() ?: 0f
                val minOrNull = volumeList.getLinkedList().minOrNull() ?: 0f
                val volumeGap = maxOrNull - minOrNull
                if (volumeGap > MAX_MIN_VOLUME_GAP && minOrNull > MIN_VOLUME) {
                    SRLogger.logD("${getClassTag()} --> onVolumeChange() --> 推测没有语音输入了 --> volumeGap = $volumeGap --> DEFAULT_VOLUME_GAP = $MAX_MIN_VOLUME_GAP")
                    mCallback?.invoke()
                    volumeList.clear()
                }
            }
        }
    }

}