package com.transsion.search.widget

import android.content.Context
import android.util.AttributeSet
import android.view.ViewGroup
import android.widget.Button

/**
 * Created by gaoxin.liu on 2025/7/31.
 * Description: 暂未使用，等后续重构尝试
 */
class HistoryFlowLayout @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ViewGroup(context, attrs, defStyleAttr) {

    private var maxLines: Int = 3 // 最大行数限制
    private var isExpanded: Boolean = false // 是否展开

    fun setMaxLines(maxLines: Int) {
        this.maxLines = maxLines
        requestLayout()
    }

    fun toggleExpanded() {
        isExpanded = !isExpanded
        requestLayout()
    }

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        val width = MeasureSpec.getSize(widthMeasureSpec)
        var height = 0

        var lineWidth = 0
        var lineHeight = 0
        var linesCount = 0

        for (i in 0 until childCount) {
            val child = getChildAt(i)
            measureChild(child, widthMeasureSpec, heightMeasureSpec)
            val childWidth = child.measuredWidth
            val childHeight = child.measuredHeight

            if (lineWidth + childWidth > width) {
                // 换行
                height += lineHeight
                lineWidth = 0
                lineHeight = 0
                linesCount++

                if (!isExpanded && linesCount >= maxLines) {
                    break // 达到最大行数限制
                }
            }

            lineWidth += childWidth
            lineHeight = maxOf(lineHeight, childHeight)
        }

        height += lineHeight // 添加最后一行高度
        setMeasuredDimension(width, height)
    }

    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {
        val width = r - l
        var lineWidth = 0
        var lineHeight = 0
        var linesCount = 0

        var curLeft = 0
        var curTop = 0

        for (i in 0 until childCount) {
            val child = getChildAt(i)
            val childWidth = child.measuredWidth
            val childHeight = child.measuredHeight

            if (lineWidth + childWidth > width) {
                // 换行
                curLeft = 0
                curTop += lineHeight
                lineWidth = 0
                lineHeight = 0
                linesCount++

                if (!isExpanded && linesCount >= maxLines) {
                    break // 达到最大行数限制
                }
            }

            child.layout(curLeft, curTop, curLeft + childWidth, curTop + childHeight)
            lineWidth += childWidth
            lineHeight = maxOf(lineHeight, childHeight)
            curLeft += childWidth
        }

        // 在最后一行添加“展开/收起”按钮
        if (!isExpanded && linesCount >= maxLines) {
            val expandButton = Button(context).apply {
                text = "展开"
                setOnClickListener { toggleExpanded() }
            }
            addView(expandButton)

            val buttonWidth = expandButton.measuredWidth
            val buttonHeight = expandButton.measuredHeight
            expandButton.layout(curLeft, curTop, curLeft + buttonWidth, curTop + buttonHeight)
        } else if (isExpanded) {
            val collapseButton = Button(context).apply {
                text = "收起"
                setOnClickListener { toggleExpanded() }
            }
            addView(collapseButton)

            val buttonWidth = collapseButton.measuredWidth
            val buttonHeight = collapseButton.measuredHeight
            collapseButton.layout(curLeft, curTop, curLeft + buttonWidth, curTop + buttonHeight)
        }
    }
}