package com.transsion.search

import android.annotation.SuppressLint
import android.text.TextUtils
import com.blankj.utilcode.util.GsonUtils
import com.google.gson.reflect.TypeToken
import com.tencent.mmkv.MMKV
import com.tn.lib.logger.Logger
import com.transsion.search.constant.SearchConstants.Companion.SEARCH_GROUP
import com.transsion.search.constant.SearchConstants.Companion.SEARCH_MOVIE
import com.transsion.search.constant.SearchConstants.Companion.SEARCH_WORK
import io.reactivex.rxjava3.disposables.Disposable


class SearchManager {

    companion object {

        @JvmStatic
        val INSTANCE: SearchManager by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            SearchManager()
        }

        const val MAX_HISTORY_COUNT = 30
        const val TAG = "VS_SM"
    }

    private var kv: MMKV? = null

    private val KV_SEARCH_GROUP = "kv_search_group"
    private val KV_SEARCH_WROK = "kv_search_work"

    private var sourceType: Int = 0


    private var keywords = mutableListOf<String>()

    constructor() {
        kv = MMKV.mmkvWithID("kv_search_list")
    }

    private var disposable: Disposable? = null

    fun clearSearch() {
        asyn {
            keywords.clear()
            when (sourceType) {
                SEARCH_WORK,
                SEARCH_MOVIE-> {
                    kv?.putString(KV_SEARCH_WROK, "")
                }
                SEARCH_GROUP -> {
                    kv?.putString(KV_SEARCH_GROUP, "")
                }
            }
        }
    }

    fun addSearch(keyword: String) {
        if (keywords.contains(keyword)) {
            keywords.remove(keyword)
            keywords.add(keyword)
        } else {
            when (sourceType) {
                SEARCH_WORK,SEARCH_MOVIE  -> {
                    if (keywords.size >= MAX_HISTORY_COUNT) {
                        keywords.removeAt(/*keywords.size - 1*/0)
                    }
                }
                SEARCH_GROUP -> {
                    if (keywords.size >= MAX_HISTORY_COUNT) {
                        keywords.removeAt(/*keywords.size - 1*/0)
                    }
                }
            }

            keywords.add(keyword)
        }
        if (keywords.isEmpty()) {
            return
        }
        asyn {
            var list = mutableListOf<String>()
            list.addAll(keywords)
            //list.reverse()
            Logger.d(TAG, "add$list")
            when (sourceType) {
                SEARCH_WORK,
                SEARCH_MOVIE -> {
                    kv?.putString(KV_SEARCH_WROK, GsonUtils.toJson(list))
                }
                SEARCH_GROUP -> {
                    kv?.putString(KV_SEARCH_GROUP, GsonUtils.toJson(list))
                }
            }

        }
    }

    fun loadSearch(sourceType: Int,callback: ISearchCallback) {
        this.sourceType = sourceType
        asyn {
            var list = findSearch()
            callback.onSearchData(list)
        }
    }


    @SuppressLint("Range")
    fun findSearch(): MutableList<String> {
        val json: String? = if (sourceType == SEARCH_GROUP) {
            kv?.getString(KV_SEARCH_GROUP, "")
        } else {
            kv?.getString(KV_SEARCH_WROK, "")
        }
        Logger.d(TAG, "findSearch$json")
        var list:MutableList<String> = if (TextUtils.isEmpty(json) || TextUtils.equals(json, "{}")) {
            mutableListOf()
        } else {
            val type = object : TypeToken<MutableList<String?>?>() {}.type
            GsonUtils.fromJson(json, type)
        }
        if(list.isNotEmpty()){
             //list.reverse()
        }
        keywords = list
        return keywords
    }

    private fun asyn(runnable: Runnable) {
        ThreadExecute.INSTANCE.execute(runnable)
    }

}