package com.transsion.search

import android.content.Context
import android.content.Intent
import com.alibaba.android.arouter.launcher.ARouter
import com.google.auto.service.AutoService
import com.transsion.baselib.service.ISearchService
import com.transsion.search.constant.SearchConstants
import com.transsion.search.constant.SearchPageIdentity

/**
 * Created by gaoxin.liu on 2024/5/16.
 * Description: 对外能力实现
 */

@AutoService(ISearchService::class)
class SearchServiceImpl : ISearchService {
    override fun openMovieSearch(hotWord: String, context: Context) {
        ARouter.getInstance().build(SearchPageIdentity.SEARCH_MANAGER)
            .withInt(SearchConstants.SEARCH_TYPE, SearchConstants.SEARCH_MOVIE)
            .withString(SearchConstants.HOT_SEARCH_WORD, hotWord)
            .navigation(context)
    }

    override fun openMovieSearch(hotWord: String, searchHotWords: List<String>, context: Context) {
        ARouter.getInstance().build(SearchPageIdentity.SEARCH_MANAGER)
            .withInt(SearchConstants.SEARCH_TYPE, SearchConstants.SEARCH_MOVIE)
            .withString(SearchConstants.HOT_SEARCH_WORD, hotWord)
            .navigation(context)

        SearchConstants.searchHotWords = searchHotWords
    }

    override fun openMovieSearch(keyword: String, hotWord: String, searchHotWords: List<String>, context: Context) {
        ARouter.getInstance().build(SearchPageIdentity.SEARCH_MANAGER)
            .withInt(SearchConstants.SEARCH_TYPE, SearchConstants.SEARCH_MOVIE)
            .withString(SearchConstants.HOT_SEARCH_WORD, hotWord)
            .withString(SearchConstants.SEARCH_KEY_WORD, keyword)
            .navigation(context)

        SearchConstants.searchHotWords = searchHotWords
    }

    override fun openGroupSearch(context: Context) {
        ARouter.getInstance().build(SearchPageIdentity.SEARCH_MANAGER)
            .withInt(SearchConstants.SEARCH_TYPE, SearchConstants.SEARCH_GROUP)
            .withString("sourceType", "0")
            .navigation(context)
    }

    override fun openAttachLinkSearch(context: Context) {
        ARouter.getInstance().build(SearchPageIdentity.SEARCH_MANAGER)
            .withInt("type", SearchConstants.SEARCH_WORK)
            .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
            .navigation(context)
    }
}