package com.transsion.search

import java.util.concurrent.ExecutorService
import java.util.concurrent.Executors

class ThreadExecute {

    companion object{

        private const val THREAD_NUM = 3

        @JvmStatic
        val INSTANCE: ThreadExecute by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
            ThreadExecute()
        }
    }

    private var executor: ExecutorService? = null


    constructor(){
        executor = Executors.newFixedThreadPool(THREAD_NUM);
    }

    fun execute(runnable: Runnable){
        executor?.submit(runnable)
    }


}