package com.transsion.search.activity

import android.util.Log
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit
import com.alibaba.android.arouter.facade.annotation.Autowired
import com.alibaba.android.arouter.facade.annotation.Route
import com.alibaba.android.arouter.launcher.ARouter
import com.tn.lib.util.networkinfo.NetworkUtil
import com.transsion.baselib.utils.ThemeUtil
import com.transsion.baseui.activity.BaseNewActivity
import com.transsion.search.R
import com.transsion.search.constant.SearchConstants
import com.transsion.search.constant.SearchPageIdentity
import com.transsion.search.databinding.ActivitySearchManagerBinding
import com.transsion.search.fragment.group.SearchUploadGroupFragment
import com.transsion.search.fragment.SearchSubjectFragment
import com.transsion.search.fragment.group.SearchUploadWorkFragment

/**
 *
 */
@Route(path = SearchPageIdentity.SEARCH_MANAGER)
class SearchManagerActivity : BaseNewActivity<ActivitySearchManagerBinding>() {

    private var mFragment: Fragment? = null

    @JvmField
    @Autowired(name = "keyword")
    var keyWord: String? = null

    @JvmField
    @Autowired(name="type")
    var searchType:Int = SearchConstants.SEARCH_MOVIE

    @JvmField
    @Autowired(name = SearchConstants.SEARCH_KEY_EXIT_WHEN_BACK)
    var backExitSearch: Boolean = false

    companion object {
        fun log(msg: String) {
            Log.w("zxb_log_search", msg)
        }
    }

    override fun getNoNetworkLayoutTitle(): String = ""

    override fun getViewBinding(): ActivitySearchManagerBinding {
        return ActivitySearchManagerBinding.inflate(layoutInflater)
    }

    override fun initViewData() {
        //
        ARouter.getInstance().inject(this)
    }

    override fun initViewModel() {
        //
    }

    override fun initListener() {
        //
    }

    override fun loadData() {

    }

    override fun loadDefaultData() {
        super.loadDefaultData()
        showFragment()
    }

    override fun retryLoadData() {
        showLoadingView()
        if (NetworkUtil.hasCapabilityAsync()) {
            showContentView()
            showFragment()
        } else {
            showNoNetworkViewDelayed()
        }
    }

    override fun isAutoShowNoNetworkLayout(): Boolean {
        // 搜索作品页，不处理无网
        return searchType != SearchConstants.SEARCH_WORK
    }

    override fun isTranslucent(): Boolean {
        return true
    }

    override fun isStatusDark(): Boolean {
        return !ThemeUtil.isDarkModeStatus()
    }

    override fun isChangeStatusBar(): Boolean {
        return !ThemeUtil.isDarkModeStatus()
    }

    private fun showFragment() {
        if (null != mFragment) {
            return
        }
        supportFragmentManager.commit(allowStateLoss = true) {
            val hotSearchWord = intent.getStringExtra(SearchConstants.HOT_SEARCH_WORD)
            //搜索作品
            mFragment = when (searchType) {
                SearchConstants.SEARCH_MOVIE -> {
                    SearchSubjectFragment.newInstance(
                        hotSearchWord,
                        keyWord,
                        backExitSearch
                    )
                }

                SearchConstants.SEARCH_GROUP -> {
                    //发布-搜索圈子
                    SearchUploadGroupFragment.newInstance(searchType)
                }

                else -> {
                    //发布-搜索作品
                    SearchUploadWorkFragment.newInstance(searchType)
                }
            }.apply {
                log("fragment = ${mFragment?.javaClass?.simpleName}")
                replace(R.id.fl_content, this)
            }
        }
    }

    override fun getPageName(): String {
        return SearchSubjectFragment.PAGE_NAME
    }

    override fun onDestroy() {
        supportFragmentManager.commit(allowStateLoss = true) {
            mFragment?.let { remove(it) }
        }
        mFragment = null
        super.onDestroy()
    }
}