package com.transsion.search.ad

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.constraintlayout.widget.ConstraintLayout.LayoutParams.PARENT_ID
import com.cloud.hisavana.sdk.api.view.TNativeView
import com.transsion.ad.view.native_ad.NativeWrapperAdView
import com.transsion.search.databinding.SearchHotHiNativeGroupLayoutBinding

/**
 * @author Connor
 * @date : 2025/9/5
 * @description: 搜索页广告容器，包含电商广告和竞价广告
 */
class SearchHotAdContainerView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private var hiNativeAdViews: MutableList<NativeWrapperAdView>? = null
    private var nativeWrapperAdView: NativeWrapperAdView? = null

    // ==================================== Hi Native ==================================

    private fun setupHiNativeAdViews() {
        removeAllViews()
        hiNativeAdViews = mutableListOf()
        val bidding = SearchHotHiNativeGroupLayoutBinding.inflate(
            LayoutInflater.from(context), this, true)
        hiNativeAdViews?.add(bidding.nativeAdView1)
        hiNativeAdViews?.add(bidding.nativeAdView2)
        hiNativeAdViews?.add(bidding.nativeAdView3)
    }

    // ================================== Bidding Native ===============================

    private fun setupNativeAdView() {
        removeAllViews()
        nativeWrapperAdView = NativeWrapperAdView(context).apply {
            id = generateViewId()
        }

        val adLayoutParams = LayoutParams(
            LayoutParams.MATCH_PARENT,
            LayoutParams.WRAP_CONTENT
        ).apply {
            startToStart = PARENT_ID
            endToEnd = PARENT_ID
            topToTop = PARENT_ID
            bottomToBottom = PARENT_ID
        }

        nativeWrapperAdView?.layoutParams = adLayoutParams
        addView(nativeWrapperAdView)
    }

    // ================================== API =========================================

    fun getHiNativeAdViews(): List<NativeWrapperAdView>? {
        if (hiNativeAdViews.isNullOrEmpty()){
            setupHiNativeAdViews()
        }
        return hiNativeAdViews
    }

    fun getNativeWrapperAdView(): NativeWrapperAdView? {
        if (nativeWrapperAdView == null) {
            setupNativeAdView()
        }
        return nativeWrapperAdView
    }

    fun destroy() {
        val parent = parent as? ViewGroup
        parent?.removeView(this)

        removeAllViews()
        hiNativeAdViews?.clear()
        nativeWrapperAdView = null
    }
}