package com.transsion.search.adapter.provider

/**
 * @author: zhiwei.chen
 * @date: 2025/3/6
 * @description: 圈子-搜索作品
 */

import android.widget.ImageView
import androidx.appcompat.widget.AppCompatTextView
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baseui.image.ImageHelper
import com.transsion.moviedetailapi.getSubjectIconId
import com.transsion.moviedetailapi.helper.SubjectHelper
import com.transsion.search.R
import com.transsion.search.adapter.SearchWorkAdapter
import com.transsion.search.bean.SearchSubject

class SearchRoomWorkProvider : BaseItemProvider<SearchSubject>() {

    override val layoutId: Int
        get() = R.layout.item_works_layout_room

    override val itemViewType: Int
        get() = SearchWorkAdapter.SEARCH_WORK_TYPE

    override fun convert(helper: BaseViewHolder, item: SearchSubject) {
        val context = helper.itemView.context
        val ivAvatar = helper.itemView.findViewById<ImageView>(R.id.ivCover)
        item.cover?.apply {
            url?.let {
                ImageHelper.loadNet(
                    context,
                    ivAvatar,
                    it,
                    thumbnail = item.cover?.thumbnail ?: "",
                    thumbScaleType = false
                )
            }
        }
        helper.setText(R.id.tvSubject, item.title)

        // 作品的简介
        helper.getViewOrNull<AppCompatTextView>(R.id.tvTag)?.let {
            it.text = SubjectHelper.getCommonTag(item)
            it.setCompoundDrawablesWithIntrinsicBounds(
                getSubjectIconId(item.subjectType),
                0,
                0,
                0
            )
        }
    }

}