package com.transsion.search.bean

import android.os.Parcelable
import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import com.transsion.moviedetailapi.bean.GifBean
import kotlinx.parcelize.Parcelize

/**
 * Created by gaoxin.liu on 2024/5/17.
 * Description:
 */

@Keep
@Parcelize
data class HotCover(
    @SerializedName("width")
    var width: Int?,
    @SerializedName("height")
    var height: Int?,
    @SerializedName("size")
    var size: Int?,
    @SerializedName("url")
    var url: String?,
    @SerializedName("format")
    var format:String?,
    @SerializedName(value = "thumbnail", alternate = ["blurHash"])
    var thumbnail:String?,
    @SerializedName("gif")
    var gifBean: GifBean?,
    @SerializedName("averageHueLight") // 图片的平均色调，亮色，返回#000000格式
    var averageHueLight:String? = null,
    @SerializedName("averageHueDark") // 图片的平均色调，暗色，返回#000000格式
    var averageHueDark:String? = null,
) : Parcelable