package com.transsion.search.bean

import android.os.Parcelable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import androidx.annotation.Keep
import androidx.core.content.ContextCompat
import com.blankj.utilcode.util.RegexUtils
import com.blankj.utilcode.util.TimeUtils
import com.transsion.moviedetailapi.SubjectType
import com.transsion.moviedetailapi.bean.Cover
import com.transsion.moviedetailapi.bean.Subject
import kotlinx.parcelize.Parcelize
import java.util.Calendar

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/1/6 20:26
 *
 *   Desc
 */

@Keep
@Parcelize
data class HotSubject(
    var subjectId: String?,
    var subjectType: Int?,
    var title: String?,
    var ops: String?,
    var releaseDate: String?,
    var genre: String?,
    var cover: HotCover?,
    var countryName: String?,
    var imdbRatingValue: String?,
    var corner: String? = null,
) : Parcelable {
    fun getDisplayFull(): String {
        val releaseDate = TimeUtils.string2Date(releaseDate, "yyyy-MM-dd")
        val calendar = Calendar.getInstance().apply { time = releaseDate }

        val sb = SpannableStringBuilder()
        sb.append(calendar.get(Calendar.YEAR).toString())

        if (!TextUtils.isEmpty(countryName)) {
            sb.append(" · ").append(countryName)
        }

        val strings = RegexUtils.getSplits(genre, ",")
        strings?.forEach {
            sb.append(" · ").append(it)
        }

        return sb.toString()
    }

    fun transferSubject(): Subject {
        return Subject(
            subjectId = subjectId,
            subjectType = subjectType,
            title = title,
            ops = ops,
            releaseDate = releaseDate,
            genre = genre,
            countryName = countryName,
            imdbRate = imdbRatingValue,
            corner =  corner
        )
    }

    fun isMusicType(): Boolean{
        return subjectType == SubjectType.MUSIC?.value || subjectType == SubjectType.AUDIO?.value
    }
}