package com.transsion.search.bean

import android.os.Parcelable
import androidx.annotation.Keep
import com.transsion.moviedetailapi.bean.Cover
import kotlinx.parcelize.Parcelize

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2023/1/6 20:26
 *
 *   Desc
 */

@Keep
@Parcelize
data class HotSubjectEntity(
    var hot: List<HotRankItem>?,
    var everyoneSearch: List<HotSearchKeyWord>?
) : Parcelable

@Keep
@Parcelize
data class HotRankItem(
    var category: String,
    var name: String,
    var items: List<HotSubject>?,
    var groups: List<GroupInfo>?,
    var index: Int = 0
) : Parcelable{
    companion object{
        const val CATE_GROUP = "Group"
        const val CATE_MUSIC = "Music"
        const val CATE_MOVIE = "Movie"
        const val CATE_TV = "TV"
    }
}


@Keep
@Parcelize
data class GroupInfo(
    var groupId: String,
    var name: String,
    var cover: Cover,
    var userCount: Long?,
    var ops:String,
    var tags: List<String>?
): Parcelable