package com.transsion.search.bean


import androidx.annotation.Keep
import com.google.gson.annotations.SerializedName
import com.transsion.moviedetailapi.bean.Staff
import com.transsion.moviedetailapi.bean.Subject
import java.io.Serializable


@Keep
data class SearchWorkEntity(

    @SerializedName("items") val items: List<SearchSubject>,
    @SerializedName("pager") val pager: Pager,
    @SerializedName("verticalRanks") val verticalRanks: List<VerticalRank>?,
    @SerializedName("counts") val counts: List<Count>,
    @SerializedName("subjectType") val subjectType: Int?, // 请求的时候的类型 作品类型(0:All 1:Movie 2:TV 4:Audio 5:Education 6:Music)
    @SerializedName("staffs") val staffs: List<Staff>?,
    @SerializedName("accurate") val accurateSubject:AccurateSubject?,//精确匹配作品
    ) : Serializable


data class AccurateSubject(
    @SerializedName("subject") val subject: SearchSubject?,
    @SerializedName("seasons") val seasons:List<Season>?,
) : Serializable

@Keep
data class Pager(
    @SerializedName("hasMore") val hasMore: Boolean,
    @SerializedName("nextPage") val nextPage: Int,
    @SerializedName("page") val page: Int,
    @SerializedName("perPage") val perPage: Int,
    @SerializedName("totalCount") val totalCount: Int
) : Serializable

@Keep
data class Count(
    var subjectType: Int?, var name: String?, var num: Int?
) : Serializable

/**
 * 这是一个业务组装类
 */
@Keep
data class SearchValuesRelatedCollectionEntity(
    val type: Int, val title: String, val verticalRank: VerticalRank?, val staff: Staff?
) : Serializable