package com.transsion.search.constant

import com.tencent.mmkv.MMKV
import com.transsion.annotations.ConfigRequestParam

/**
 *   Transsion MI
 *   Created By Liupeng
 *   On 2022/7/18 11:29
 *
 *   Desc
 */
class SearchConstants {


    companion object {
        val searchMmKV: MMKV by lazy {
            MMKV.mmkvWithID("search_mmKv")
        }

        const val SEARCH_WORK = 1
        const val SEARCH_GROUP = 2
        const val SEARCH_MOVIE = 3

        const val SEARCH_TYPE = "type"
        /**
         * 热搜词
         */
        const val HOT_SEARCH_WORD = "hot_search_word"

        /**
         * 搜索关键词，进入搜索页面拿到该keyword需要执行一次搜索
         */
        const val SEARCH_KEY_WORD = "keyword"

        const val SEARCH_KEY_EXIT_WHEN_BACK = "back_exit"

        var searchHotWords: List<String>? = null

        @ConfigRequestParam
        const val SEARCH_HISTORY_LINES_DOUBLE = "sa_history_lines_double"
    }
}