package com.transsion.search.fragment.group

import android.annotation.SuppressLint
import android.net.Network
import android.net.NetworkCapabilities
import android.os.Bundle
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.Gravity
import android.view.KeyEvent
import android.view.LayoutInflater
import android.view.View
import android.view.inputmethod.EditorInfo
import android.widget.ImageView
import android.widget.TextView
import androidx.appcompat.widget.AppCompatTextView
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.OnScrollListener
import com.alibaba.android.arouter.launcher.ARouter
import com.blankj.utilcode.util.ColorUtils
import com.blankj.utilcode.util.GsonUtils
import com.blankj.utilcode.util.KeyboardUtils
import com.tn.lib.ext.gone
import com.tn.lib.ext.visible
import com.tn.lib.util.networkinfo.NetworkUtil
import com.tn.lib.util.networkinfo.OnNetworkStatusChangedListener
import com.tn.lib.widget.dialog.TRDialog
import com.tn.lib.widget.dialog.TRDialogListener
import com.tn.lib.widget.toast.TRToast
import com.tn.lib.widget.toast.core.ToastUtils
import com.transsion.baselib.helper.DataHelper
import com.transsion.baselib.report.LogViewConfig
import com.transsion.baseui.fragment.BaseFragment
import com.transsion.baseui.recycler.LoadMoreOnScrollListener
import com.transsion.moviedetailapi.MovieDetailConstants
import com.transsion.moviedetailapi.MovieDetailPageIdentity
import com.transsion.moviedetailapi.SubjectType
import com.transsion.publish.api.GroupBean
import com.transsion.publish.api.OperationMenu
import com.transsion.search.constant.Constant
import com.transsion.search.ISearchCallback
import com.transsion.search.R
import com.transsion.search.SearchManager
import com.transsion.search.fragment.group.adapter.SearchGroupAdapter
import com.transsion.search.fragment.group.adapter.SearchKeywordAdapter
import com.transsion.search.adapter.SearchWorkAdapter
import com.transsion.search.constant.SearchConstants
import com.transsion.search.bean.BackEntity
import com.transsion.search.databinding.FragmentPublishSearchBinding
import com.transsion.search.dialog.CheckDialogListener
import com.transsion.search.dialog.CheckTipsDialog
import com.transsion.search.fragment.SearchSubjectFragment
import com.transsnet.downloader.DownloadManagerApi
import com.transsnet.flow.event.postEvent

/**
 *  发帖用搜索  搜索圈子
 */
class SearchUploadGroupFragment : BaseFragment<FragmentPublishSearchBinding>(), TRDialogListener {

    private var isRefreshing: Boolean = false
    private var mSearchGroupAdapter: SearchGroupAdapter? = null
    private var mSearchKeywordAdapter: SearchKeywordAdapter? = null
    private var mSearchWorkAdapter: SearchWorkAdapter? = null
    private var mHistoryList = mutableListOf<String>()

    private var mSearchViewModel: com.transsion.search.viewmodel.SearchViewModel? = null
    private var mType: Int = 0
    private var page: Int = 1
    private var perPage: Int = 10

    private var mKeyword: String = ""
    private var selectGroup: GroupBean? = null

    private val mCheckTipsDialog: CheckTipsDialog by lazy { CheckTipsDialog.newInstance() }

    override fun getViewBinding(inflater: LayoutInflater): FragmentPublishSearchBinding {
        return FragmentPublishSearchBinding.inflate(inflater)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        mType = arguments?.getInt("type") ?: SearchConstants.SEARCH_WORK
        when (mType) {
            SearchConstants.SEARCH_WORK,
            SearchConstants.SEARCH_MOVIE
            -> {
                mSearchWorkAdapter = SearchWorkAdapter(requireContext(), mutableListOf()).apply {
                    loadMoreModule.setOnLoadMoreListener {
                        if (NetworkUtil.hasCapabilityAsync()) {
                            mSearchViewModel?.searchWork(page, perPage, mKeyword)
                        } else {
                            TRToast.show(com.tn.lib.widget.R.string.no_network_toast)
                            mViewBinding?.rv?.postDelayed({
                                mSearchWorkAdapter?.loadMoreModule?.loadMoreFail()
                            }, 300)
                        }
                    }

                    setOnItemClickListener { _, view, position ->
                        mSearchWorkAdapter?.data?.get(position)?.let {
                            reportClick("", it.subjectId, it.ops, position)
                            if(mType == SearchConstants.SEARCH_MOVIE){
                                if (it.subjectType == SubjectType.SHORT_TV.value) {
                                    DownloadManagerApi.INSTANCE.downloadShortTV(
                                        activity = context as FragmentActivity,
                                        page_from = SearchSubjectFragment.PAGE_NAME,
                                        groupId = "",
                                        opss = it.ops,
                                        moduleName = "download_subject",
                                        scroll2Download = false,
                                        subject = it
                                    )
                                } else {
                                    ARouter.getInstance().build(MovieDetailPageIdentity.MOVIE_DETAIL)
                                        .withInt(MovieDetailConstants.SUBJECT_TYPE, it.subjectType ?: SubjectType.MOVIE.value)
                                        .withString(MovieDetailConstants.SUBJECT_ID, it.subjectId)
                                        .withString(MovieDetailConstants.OPS, it.ops)
                                        .navigation()
                                }
                                return@let
                            }
                            var opertaion = OperationMenu()
                            opertaion.item_type = Constant.ITEM_WORKS
                            opertaion.item_operation = Constant.OPERATION_ADD
                            opertaion.subject = it
                            postEvent(opertaion)
                            activity?.finish()
                        }
                    }
                }
                mViewBinding?.rv?.layoutManager =
                    LinearLayoutManager(requireContext(), LinearLayoutManager.VERTICAL, false)
                mViewBinding?.rv?.adapter = mSearchWorkAdapter
                mViewBinding?.rv?.addOnScrollListener(LoadMoreOnScrollListener(mSearchWorkAdapter?.loadMoreModule))
            }
            SearchConstants.SEARCH_GROUP -> {
                mViewBinding?.commentInputEditText?.setHint(R.string.search_hint_input_group)
                mSearchGroupAdapter = SearchGroupAdapter().apply {
                    loadMoreModule.setOnLoadMoreListener {
                        if (NetworkUtil.hasCapabilityAsync()) {
                            mSearchViewModel?.searchGroup(page, perPage, mKeyword)
                        } else {
                            TRToast.show(com.tn.lib.widget.R.string.no_network_toast)
                            mViewBinding?.rv?.postDelayed({
                                mSearchWorkAdapter?.loadMoreModule?.loadMoreFail()
                            }, 300)
                        }
                    }

                    setOnItemClickListener { _, view, position ->
                        mSearchGroupAdapter?.data?.get(position)?.let {
                            selectGroup = it
                            reportClick(it.groupId,"",it.ops,position)
                            postFinsh()
                            postGroup(selectGroup)
                            activity?.finish()
                        }
                    }
                }
                mViewBinding?.rv?.addOnScrollListener(LoadMoreOnScrollListener(mSearchGroupAdapter?.loadMoreModule))

            }
        }
        mViewBinding?.tvClear?.setOnClickListener {
            clearTipsDialog()
        }
        mSearchKeywordAdapter = SearchKeywordAdapter()
        mSearchKeywordAdapter?.addChildClickViewIds(R.id.tv_keyword)
        mSearchKeywordAdapter?.setOnItemChildClickListener { adapter, view, position ->
            when (view.id) {
                R.id.tv_keyword -> {
                    activity?.let { KeyboardUtils.hideSoftInput(it) }
                    mKeyword = mSearchKeywordAdapter?.getItem(position).toString()
                    mViewBinding?.commentInputEditText?.setText(mKeyword)
                    mKeyword.length?.let { mViewBinding?.commentInputEditText?.setSelection(it) }
                    mViewBinding?.loadView?.visibility = View.VISIBLE

                    when (mType) {
                        SearchConstants.SEARCH_WORK,
                        SearchConstants.SEARCH_MOVIE-> {
                            page = 1
                            searchJob()
                        }
                        SearchConstants.SEARCH_GROUP -> {
                            page = 1
                            searchJob()
                        }
                    }
                    SearchManager.INSTANCE.addSearch(mKeyword)
                }
            }
        }
        mViewBinding?.rv?.layoutManager =
            LinearLayoutManager(requireContext(), LinearLayoutManager.VERTICAL, false)
        mViewBinding?.rv?.adapter = mSearchKeywordAdapter
        SearchManager.INSTANCE.loadSearch(mType,object : ISearchCallback {
            override fun onSearchData(list: MutableList<String>) {
                activity?.runOnUiThread {
                    if (list.isNotEmpty()) {
                        //mViewBinding?.rlTips?.visibility = View.VISIBLE
                        var showlist =  mutableListOf<String>()
                        showlist.addAll(list)
                        showlist.reverse()
                        mHistoryList = showlist
                        mSearchKeywordAdapter?.setNewInstance(showlist)
                    } else {
                        mViewBinding?.rlTips?.visibility = View.GONE
                    }
                }
            }
        })
        initViewModel()
        mViewBinding?.commentInputEditText?.setOnClickListener {
            mViewBinding?.tvSearch?.visible()
        }
        mViewBinding?.commentInputEditText?.setOnFocusChangeListener { view, hasFocus ->
            view.dispatchWindowFocusChanged(hasFocus);
            if (hasFocus) {
                when (mType) {
                    SearchConstants.SEARCH_WORK,
                    SearchConstants.SEARCH_MOVIE-> {
                        if(mSearchWorkAdapter?.data?.isNullOrEmpty() == true){
                            mViewBinding?.rlTips?.visibility = View.VISIBLE
                            mSearchKeywordAdapter?.setNewInstance(mHistoryList)
                        }
                    }
                    SearchConstants.SEARCH_GROUP -> {
                        if(mSearchGroupAdapter?.data?.isNullOrEmpty() == true){
                            mViewBinding?.rlTips?.visibility = View.VISIBLE
                            mSearchKeywordAdapter?.setNewInstance(mHistoryList)
                        }
                    }
                }
            }
            val json = GsonUtils.toJson(mHistoryList)
            logViewConfig?.paramsMap?.set("keyword",json)
        }
        mViewBinding?.tvSearch?.setOnClickListener {
            searchJob()
        }
        mViewBinding?.commentInputEditText?.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
                mViewBinding?.tvSearch?.visible()
            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
            }

            override fun afterTextChanged(s: Editable?) {
                var length = s?.length?:0
                if (length > 0) {
                    mViewBinding?.ivClear?.visibility = View.VISIBLE
                } else {
                    mViewBinding?.ivClear?.visibility = View.GONE
                    resetContent(true)
                }
                mKeyword = s.toString()
            }
        })
        mViewBinding?.commentInputEditText?.setOnEditorActionListener(object :
            TextView.OnEditorActionListener {
            override fun onEditorAction(tv: TextView?, i: Int, keyEvent: KeyEvent?): Boolean {
                if (i == EditorInfo.IME_ACTION_SEARCH || i == EditorInfo.IME_ACTION_UNSPECIFIED) {
                    mKeyword = tv?.text.toString()
                    searchJob()
                    return true
                }
                return false
            }

        })
        /*mViewBinding?.commentInputEditText?.setOnKeyListener { v, keyCode, event ->
            if (keyCode == KeyEvent.KEYCODE_DEL) {
                resetContent()
            }
            false
        }*/
        mViewBinding?.ivClear?.setOnClickListener {
            resetContent(false)
        }
        mViewBinding?.loadView?.gone()
        mCheckTipsDialog.setListener(object : CheckDialogListener{

            override fun cancelDialogBtn() {

            }

            override fun affirmDialogBtn() {
                selectGroup?.groupId?.let { mSearchViewModel?.joinGroup(it) }
            }

        })
        mViewBinding?.ivCancel?.setOnClickListener {
            postFinsh()
            activity?.finish()
        }
        mViewBinding?.commentInputEditText?.requestFocus()
        mViewBinding?.commentInputEditText?.let { KeyboardUtils.showSoftInput(it) }
        logViewConfig?.isLoadSuccess = true

        mViewBinding?.rv?.addOnScrollListener(object : OnScrollListener(){
            override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
                super.onScrollStateChanged(recyclerView, newState)
                if (newState == RecyclerView.SCROLL_STATE_DRAGGING) {
                    activity?.apply {
                        if (KeyboardUtils.isSoftInputVisible(this)) {
                            mViewBinding?.commentInputEditText?.let { KeyboardUtils.hideSoftInput(it) }
                        }
                    }
                }
            }
        })
    }



    override fun initView(view: View, savedInstanceState: Bundle?) {
        netListener = object : OnNetworkStatusChangedListener {
            override fun onDisconnected() {}
            override fun onConnected(network: Network, networkCapabilities: NetworkCapabilities) {
                if (mSearchWorkAdapter?.data?.isEmpty() == true) {
                    searchJob()
                } else {
                    mSearchWorkAdapter?.loadMoreModule?.loadMoreToLoading()
                }
                if (mSearchGroupAdapter?.data?.isEmpty() == true) {
                    searchJob()
                } else {
                    mSearchGroupAdapter?.loadMoreModule?.loadMoreToLoading()
                }
            }
        }
    }

    private fun resetContent(clear: Boolean){
        if (!clear) {
            mViewBinding?.commentInputEditText?.setText("")
            mKeyword = ""
        }
        when (mType) {
            SearchConstants.SEARCH_WORK,
            SearchConstants.SEARCH_MOVIE-> {
                mSearchWorkAdapter?.setNewInstance(mutableListOf())
                mSearchWorkAdapter?.removeEmptyView()

                var showlist =  mutableListOf<String>()
                showlist.addAll(SearchManager.INSTANCE.findSearch())
                showlist.reverse()
                mHistoryList = showlist
                mSearchKeywordAdapter?.setNewInstance(showlist)
                mViewBinding?.rv?.adapter = mSearchKeywordAdapter
                if(showlist.isNotEmpty()) {
                    mViewBinding?.rlTips?.visibility = View.VISIBLE
                }else{
                    mViewBinding?.rlTips?.visibility = View.GONE

                }
            }
            SearchConstants.SEARCH_GROUP -> {
                mSearchGroupAdapter?.setNewInstance(mutableListOf())
                mSearchWorkAdapter?.removeEmptyView()
            }
        }
        mViewBinding?.commentInputEditText?.let { it1 -> KeyboardUtils.showSoftInput(it1) }
    }

    private fun postFinsh(){
        var back = BackEntity()
        postEvent(back)
    }

    private fun postGroup(groupBean: GroupBean?){
        var opertaion = OperationMenu()
        opertaion.item_type = Constant.ITEM_GROUP
        opertaion.item_operation = Constant.OPERATION_ADD
        opertaion.group = groupBean
        postEvent(opertaion)
    }

    private fun searchJob() {
        if (TextUtils.isEmpty(mKeyword)) {
            if (mType == SearchConstants.SEARCH_GROUP) {
                ToastUtils.setGravity(Gravity.CENTER_VERTICAL)
                ToastUtils.show(getString(R.string.tips_room))
            } else {
                ToastUtils.setGravity(Gravity.CENTER_VERTICAL)
                ToastUtils.show(getString(R.string.tips_movie))
            }
            return
        }
        isRefreshing = true
        SearchManager.INSTANCE.addSearch(mKeyword)
        KeyboardUtils.hideSoftInput(mViewBinding?.commentInputEditText!!)
        if (!NetworkUtil.hasCapabilityAsync()) {
            //TRToast.show(R.string.search_net_err)
            when (mType) {
                SearchConstants.SEARCH_WORK,
                SearchConstants.SEARCH_MOVIE -> {
                    mSearchWorkAdapter?.setEmptyView(emptyView())
                    mSearchWorkAdapter?.setNewInstance(mutableListOf())
                }
                SearchConstants.SEARCH_GROUP -> {
                    mSearchGroupAdapter?.setEmptyView(emptyView())
                    mSearchGroupAdapter?.setNewInstance(mutableListOf())
                }
            }
            return
        }
        mViewBinding?.loadView?.visible()
        mViewBinding?.tvSearch?.gone()
        when (mType) {
            SearchConstants.SEARCH_WORK,
            SearchConstants.SEARCH_MOVIE -> {
                page = 1
                mSearchViewModel?.searchWork(page, perPage, mKeyword)
            }
            SearchConstants.SEARCH_GROUP -> {
                page = 1
                mSearchViewModel?.searchGroup(page, perPage, mKeyword)
            }
        }
        val map = HashMap<String, String>()
        map["module_name"] = "search"
        map["key_word"] = mKeyword
        map["type"] = mType.toString()
        DataHelper.reportFeedClickEvent("searchpage", map)
    }

    @SuppressLint("InflateParams")
    private fun initViewModel() {
        mSearchViewModel =
            ViewModelProvider(requireActivity())[com.transsion.search.viewmodel.SearchViewModel::class.java].apply {
                getSearchGroupLiveData().observe(this@SearchUploadGroupFragment.viewLifecycleOwner) {
                    val dataList =  it?.items
                    val hasMore =  it?.pager?.hasMore ?: false
                    page = it?.pager?.nextPage?.toIntOrNull() ?: 1
                    perPage = it?.pager?.perPage ?: 10
                    mViewBinding?.loadView?.gone()
                    mSearchGroupAdapter?.apply {
                        loadMoreModule.loadMoreComplete()
                        if (dataList.isNullOrEmpty()) {
                            mSearchGroupAdapter?.setNewInstance(mutableListOf())
                            setEmptyView(emptyView())
                            isUseEmpty = true
                        }
                        if (mViewBinding?.rv?.adapter is SearchKeywordAdapter) {
                            mViewBinding?.rlTips?.visibility = View.GONE
                            mViewBinding?.rv?.adapter = mSearchGroupAdapter
                        }
                        if (!dataList.isNullOrEmpty()) {
                            val filter =
                                dataList.filter { item -> mSearchGroupAdapter?.data?.contains(item) == false }
                            if (filter.isNotEmpty()) {
                                if (isRefreshing){
                                    isRefreshing = false
                                    mSearchGroupAdapter?.setList(filter)
                                }else{
                                    mSearchGroupAdapter?.addData(filter)

                                }
                            } else {
                                loadMoreModule.loadMoreEnd(false)
                            }
                        }
                        if (hasMore) {
//                            loadMoreModule.isEnableLoadMore = hasMore
//                            loadMoreModule.isAutoLoadMore = hasMore
                        } else {
                            loadMoreModule.loadMoreEnd(false)
                        }
                        if (null == it) {
                            loadMoreModule.loadMoreFail()
                        }
                    }
                }
                getSearchWorkLiveData().observe(this@SearchUploadGroupFragment.viewLifecycleOwner) {
                    val dataList =  it?.items
                    val hasMore =  it?.pager?.hasMore ?: false
                    page = it?.pager?.nextPage ?: 1
                    perPage = it?.pager?.perPage ?: 10
                    mViewBinding?.loadView?.gone()
                    mSearchWorkAdapter?.apply {
                        loadMoreModule.loadMoreComplete()
                        var empty = mSearchWorkAdapter?.data?.isEmpty()
                        if (dataList.isNullOrEmpty() && empty == true && (page == 1 || it?.pager?.page == 1)) {
                            mSearchWorkAdapter?.setNewInstance(mutableListOf())
                            setEmptyView(emptyView())
                            isUseEmpty = true
                        }
                        if (mViewBinding?.rv?.adapter is SearchKeywordAdapter) {
                            mViewBinding?.rlTips?.visibility = View.GONE
                            mViewBinding?.rv?.adapter = mSearchWorkAdapter
                        }
                        if (!dataList.isNullOrEmpty()) {
                            if (isRefreshing) {
                                isRefreshing = false
                                mSearchWorkAdapter?.setList(dataList)
                            } else {
                                mSearchWorkAdapter?.addData(dataList)
                            }
                            logViewConfig?.isLoadSuccess = true
                            logViewConfig?.paramsMap?.set("type", mType.toString())

                        } else {
                            loadMoreModule.loadMoreEnd(false)
                        }
                        if (hasMore) {
//                            loadMoreModule.isEnableLoadMore = hasMore
//                            loadMoreModule.isAutoLoadMore = hasMore
                        } else {
                            loadMoreModule.loadMoreEnd(false)
                        }
                        if (null == it) {
                            loadMoreModule.loadMoreFail()
                        }
                    }
                }
                getJoinGroupLiveData().observe(this@SearchUploadGroupFragment.viewLifecycleOwner){
                    if(TextUtils.isEmpty(it)){
                        return@observe
                    }
                    if(selectGroup == null){
                        return@observe
                    }
                    postFinsh()
                    postGroup(selectGroup)
                    activity?.finish()
                }

            }
    }

    override fun lazyLoadData() {
        //mSearchFragment.loadView.playAnimation()
        //mSearchViewModel?.fetchFollower(mUserId, timestamp, mType)
    }

    private fun emptyView(): View {
        val view =
            layoutInflater.inflate(R.layout.view_search_manager_empty, null)
        val emptyTipsView = view.findViewById<TextView>(R.id.tv_empty_tips)
        val imageView = view.findViewById<ImageView>(R.id.iv_tips)
        val retryBtn = view.findViewById<AppCompatTextView>(R.id.tv_retry)
        if (NetworkUtil.hasCapabilityAsync()) {
            //emptyTipsView.setText(if (mType ==  SearchConstants.SEARCH_GROUP) R.string.user_follower_empty else R.string.user_works_empty)
            var keyword = mViewBinding?.commentInputEditText?.text.toString()
            emptyTipsView.text = getString(R.string.user_works_empty) + " \"" + keyword + "\""
            retryBtn.visibility = View.GONE
            imageView.setImageResource(com.tn.lib.widget.R.mipmap.ic_no_content)
        } else {
            emptyTipsView.setText(com.transsion.baseui.R.string.base_net_err)
            imageView.setImageResource(com.tn.lib.widget.R.mipmap.ic_no_network)
            retryBtn.visibility = View.VISIBLE
            retryBtn.setOnClickListener {
               searchJob()
            }
        }
        return view
    }

    private fun clearTipsDialog() {
        try {
            TRDialog.Builder()
                .setTitle(getString(R.string.search_clear_title))
                .setMessage(getString(R.string.search_clear_des))
                .setLeftText(getString(R.string.search_clear_cancel))
                .setRightText(getString(R.string.search_clear_clear))
                .setRightBtnResId(R.drawable.btn_bg_dialog_edit_selector)
                .setLeftBtnResId(R.drawable.btn_bg_dialog_edit_selector)
                .setRightBtnTextColor(ColorUtils.getColor(com.transsion.baseui.R.color.base_color_black))
                .setListener(this)
                .build().showDialog(this, "clear_tips");
        } catch (e: Exception) {

        }
    }

    private fun showCheckDialog() {
        mCheckTipsDialog.showDialog(this, "mCheckTipsDialog")
    }

    companion object {

        fun newInstance(type: Int): SearchUploadGroupFragment {
            val fragment = SearchUploadGroupFragment()
            val bundle = Bundle()
            //bundle.putString("userId", userId)
            bundle.putInt("type", type)
            fragment.arguments = bundle
            return fragment
        }
    }

    override fun onDestroyView() {
        mViewBinding?.loadView?.gone()
        super.onDestroyView()
    }

    override fun onLeftButtonClick(dialog: TRDialog) {
    }

    override fun onRightButtonClick(dialog: TRDialog) {
        if (TextUtils.equals(dialog.tag, "clear_tips")) {
            SearchManager.INSTANCE.clearSearch()
            mViewBinding?.rlTips?.visibility = View.GONE
            mSearchKeywordAdapter?.setNewInstance(mutableListOf())
        }
    }


    private fun reportClick(group_id: String?, subject_id: String?, opt: String?, position: Int) {
        val map = HashMap<String, String>()
        map["group_id"] = group_id ?: ""
        map["subject_id"] = subject_id ?: ""
        map["sequence"] = position.toString()
        map["ops"] = opt ?: ""

        DataHelper.reportFeedClickEvent("searchresult",map)
    }

    override fun newLogViewConfig(): LogViewConfig? {
        return LogViewConfig("searchpage")
    }


}