package com.transsion.search.fragment.group.adapter

import android.widget.ImageView
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baselib.helper.DataHelper
import com.transsion.baseui.image.ImageHelper
import com.transsion.baseui.util.ShowRuleUtil
import com.transsion.publish.api.GroupBean
import com.transsion.search.R


class SearchGroupAdapter(layoutResId: Int = R.layout.item_search_group) :
    BaseQuickAdapter<GroupBean, BaseViewHolder>(layoutResId),
    LoadMoreModule {

    val width = SizeUtils.dp2px(48f)
    val height = SizeUtils.dp2px(48f)
    override fun convert(holder: BaseViewHolder, item: GroupBean) {
        holder.setText(R.id.tv_name, item.name)
        holder.setText(R.id.tv_des, ShowRuleUtil.getLikesFormat(item.userCount) + " checkin")
        holder.setVisible(R.id.iv_select,item.select)
        val context = holder.itemView.context
        val ivAvatar = holder.itemView.findViewById<ImageView>(R.id.iv_avatar)
        item.avatar?.let {
            ImageHelper.loadNet(
                context, ivAvatar,
                it, com.tn.lib.widget.R.color.cl34_ff, width, height
            )
        }
        report(item,getItemPosition(item))
    }

    private fun report(item: GroupBean, sequence: Int) {
        val map = HashMap<String, String>()
        map["group_id"] = item.groupId ?: ""
        map["sequence"] = sequence.toString()
        map["ops"] = item.ops ?: ""
        DataHelper.reportBrowseEvent("searchresult", map)
    }
}