package com.transsion.search.fragment.result

import android.os.Parcelable
import androidx.annotation.Keep
import com.transsion.moviedetailapi.bean.Group
import com.transsion.moviedetailapi.bean.Staff
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.bean.VerticalRank
import kotlinx.parcelize.Parcelize

/**
 * Created by gaoxin.liu on 2025/3/19.
 * Description: 用于渲染的数据，需要API返回转换
 */
@Keep
@Parcelize
data class ResultWrapData(
    val type: ResultType,

    val subject: Subject? = null, //作品数据
    val staff: Staff? = null,  //演员数据
    val groups: Group? = null, //圈子数据
    val verticalRank: VerticalRank? = null, //榜单数据

    //跳转数据
    val title: String? = null,
    val moreTabId: String? = null,
): Parcelable

enum class ResultType {
    SUBJECT,
    STAFF,
    GROUP,
    VERTICAL_RANK,
    TITLE,
    MORE
}