package com.transsion.search.fragment.result.adapter

import androidx.recyclerview.widget.LinearLayoutManager
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.baselib.exposure.ListExposureHelper
import com.transsion.moviedetailapi.bean.Subject
import com.transsion.search.fragment.result.ResultWrapData
import com.transsion.search.fragment.result.provider.ResultGroupProvider
import com.transsion.search.fragment.result.provider.ResultMoreProvider
import com.transsion.search.fragment.result.provider.ResultRankProvider
import com.transsion.search.fragment.result.provider.ResultStaffProvider
import com.transsion.search.fragment.result.provider.ResultSubjectProvider
import com.transsion.search.fragment.result.provider.ResultTitleProvider
import com.transsion.search.widget.SearchReportHelper

/**
 * Created by gaoxin.liu on 2025/3/18.
 * Description:
 */
class SearchResultTabAdapter(
    private val exposureHelper: ListExposureHelper?,
    private val keyword: String?,
    private val searchFrom: String?,
    private var tabId: String?) : BaseProviderMultiAdapter<ResultWrapData>(), LoadMoreModule {

    init {
        addItemProvider(ResultGroupProvider())
        addItemProvider(ResultMoreProvider())
        addItemProvider(ResultRankProvider())
        addItemProvider(ResultStaffProvider())
        addItemProvider(ResultSubjectProvider())
        addItemProvider(ResultTitleProvider())
    }

    override fun getItemType(data: List<ResultWrapData>, position: Int): Int {
        return data[position].type.ordinal
    }

    /**
     * 埋点取该tabId，确保数据的准确性
     */
    fun setCurrentTab(tabId: String) {
        this.tabId = tabId
    }

    fun getCurrentTabId(): String? {
        return tabId
    }

    //部分内部点击元素上报
    fun reportSubjectClick(subject: Subject?, position: Int) {
        SearchReportHelper.reportSubjectClick(subject, position, keyword, searchFrom, tabId)
    }

    override fun onViewAttachedToWindow(holder: BaseViewHolder) {
        super.onViewAttachedToWindow(holder)
        val position = holder.bindingAdapterPosition
        exposureHelper?.onAdapterChange(this.recyclerView.layoutManager as LinearLayoutManager, position, true)
    }
}