package com.transsion.search.fragment.result.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.search.R
import com.transsion.search.bean.TabItem

/**
 * Created by gaoxin.liu on 2025/3/18.
 * Description: 结果页二级tab
 */
class SearchResultTabHeaderAdapter(initId: String?): BaseQuickAdapter<TabItem, BaseViewHolder>(R.layout.item_search_result_tab) {
    private var selectedId: String? = null

    init {
        selectedId = initId
    }

    fun setSelectedTab(selectId: String) {
        selectedId = selectId
        notifyDataSetChanged()
    }

    override fun convert(holder: BaseViewHolder, item: TabItem) {
        holder.setText(R.id.search_result_tab_select_text, item.name)
        holder.setText(R.id.search_result_tab_default_text, item.name)

        if (item.tabId == selectedId) {
            holder.setVisible(R.id.search_result_tab_select_text, true)
            holder.setGone(R.id.search_result_tab_default_text, true)

        } else {
            holder.setGone(R.id.search_result_tab_select_text, true)
            holder.setVisible(R.id.search_result_tab_default_text, true)
        }
    }
}